sap.ui.define([
    "sap/ui/core/Icon",
	"sap/m/Panel",
	"sap/m/PanelRenderer",
	"sap/m/HBox"
], function(Icon, Panel, PanelRenderer, HBox) {
    "use strict";

	var Group = Panel.extend("SUMControls.Group", {

		metadata: {
			properties: {
				type:     {type: "string", defaultValue: null},
			}
		},

	    renderer: function(oRm, oControl) {
	    	oRm.addClass("sapUiNoMargin");
			if (oControl.getExpandable()) oRm.addStyle('font-size', '20px');
	        if (oControl.getType() === "error") {
	        	oRm.addStyle('background-color', '#ffe4e4');
				if (!oControl.getExpandable()) {
					oRm.addStyle('border', '1px solid');
					oRm.addStyle('border-color', '#ee0000');
					oRm.addStyle('border-radius', '0.1875rem');
					oRm.addStyle('padding-left', '1rem');
					oRm.addStyle('padding-right', '1rem');
					oRm.addStyle('width','auto !important');
				}
        	}
			PanelRenderer.render(oRm, oControl);
	    },

		onAfterRendering: function(oEvt) {
			if (this.getExpandable()) {
				if (!this.getExpanded()) this.$().children(".sapMPanelExpandablePart").hide();
			} else {
				$(this.getDomRef()).removeClass("sapMPanel");
				$(this.getDomRef("content")).removeClass("sapMPanelContent");
				$(this.getDomRef("content")).removeClass("sapMPanelBGTranslucent");
				$(this.getDomRef("header")).removeClass("sapMPanelHdr");
				if (this.icon) {
					var st = this.icon.getDomRef().style;
					st.paddingRight = "0.5rem";
					st.fontSize = "1rem";
				}
 
			}
			if (this.swOn) {
				this.swOn = false;
			}
		}
	});

	return Group;
});  