sap.ui.define([
    "sap/ui/core/Icon",
	"sap/m/Popover",
	"sap/ui/core/Control"
], function(Icon, Popover, Ctrl) {
  "use strict";

	var Hint = Icon.extend("SUMControls.Hint", {	// call the new Control type "Hint" 
													// and let it inherit from sap.m.Icon
		metadata: {
			properties: {
				src: 			{type: "string", defaultValue: "sap-icon://message-information"},
				color: 			{type: "string", defaultValue: document.URL.indexOf("suihcb=true")>0 ? "#FFFFFF" : document.URL.indexOf("suihcw=true")>0 ? "#000000" : "green"},
				htmlText:		{type: "string"},
				contentWidth:	{type: "sap.ui.core.CSSSize", defaultValue: "auto"}
			},
			aggregations: {
				content: 		{type: "sap.ui.core.Control"}
			},
			defaultAggregation: "content"
		},	
		
		init: function() {
			this.oHtml = new sap.m.FormattedText();
			this.oBox = new sap.m.FlexBox();
			this.oBox.addStyleClass("sapUiTinyMargin");
			this.oPopover = new Popover({placement: "Right", showHeader: false, resizable: true});
			this.attachPress(function(){this.oPopover.openBy(this);});
			this.oPopover.addContent(this.oBox);
			this.oPopover.setContentWidth(this.getContentWidth());
			this.oPopover.addStyleClass("sapUiTinyMargin");
		},		
	
		onBeforeRendering: function() {
			if (this.getHtmlText()) {this.oHtml.setHtmlText(this.getHtmlText()); this.oBox.addItem(this.oHtml);}
			else this.getContent().forEach($.proxy(function(a){this.oBox.addItem(a);}, this));
  		},		
	
	    renderer: function(oRm, oControl) {
	        oRm.addStyle('vertical-align', 'middle');  
	        oRm.addStyle('padding-left', '5px');  
	        sap.ui.core.IconRenderer.render(oRm, oControl);
	    },  
		
        exit: function() {
    		if (this.oPopover) {
    			this.oPopover.destroy();			// destroy aggregated content
    			delete this.oPopover;
    		}
    		if (this.oBox) {
    			this.oBox.destroy();
    			delete this.oBox;
    		}
    		if (this.oHtml) {
    			this.oHtml.destroy();
    			delete this.oHtml;
    		}
		}
	});
	
  return Hint;
});