sap.ui.define([
    "sap/m/Input"
], function(Input) {
  "use strict";

	var _Input = Input.extend("SUMControls.Input", {	// call the new Control type "Input" 
														// and let it inherit from sap.m.Input
		metadata: {
		    properties: {
                remId:   {type: "string", defaultValue: null},
                remArg:  {type: "string", defaultValue: null}
            },
			aggregations: {
				hint: {
					type: "SUMControls.Hint"
				}
			},
			defaultAggregation: "hint"
		},	
	
	    renderer: function(oRm, oControl) {
			var hints = oControl.getHint();
			if (hints.length) oRm.write("<div style=\"display:flex; flex-direction: row;\">");
			if (oControl.getType() === sap.m.InputType.Password) oRm.write("<form>");
	        sap.m.InputRenderer.render(oRm, oControl);
			if (oControl.getType() === sap.m.InputType.Password) oRm.write("</form>");
			if (hints.length) { 
				hints.forEach(function(a){oRm.renderControl(a);});
				oRm.write("</div>");
			}
	    },  

		onAfterRendering: function(oEvt) {
			$("#"+oEvt.srcControl.getId()+"-inner").attr("sumid", oEvt.srcControl.data("sumid"));
		}
		
	});
	
  return _Input;
});  