sap.ui.define([
	"sap/ui/core/Control",
	"sap/m/Button",
	"sap/m/FormattedText",
	"sap/m/Dialog",
], function(Control, Button, FormattedText, Dialog) {
	"use strict";

	var LogViewer = Control.extend("SUMControls.LogViewer", {
		
		metadata: {
			properties: {
				logFile : { type: "String", defaultValue: null }
			},
			events: {
				closed : {}
			}
		},
		
		init : function() {
			this._mayUpdate = true;
			
			this._oDialog = new Dialog({
				title: 'Log: ' + this.getProperty("logFile"),
				type: 'Message',
				
				resizable: true,
				draggable: true,
				
				contentWidth: '90%',
				contentHeight: '90%',

				content: new FormattedText({
					htmlText: '<code>Loading content ...</code>'
				}),
				
				beginButton: new Button({
					text: 'Close',
					press: function() {
						this._oDialog.close();
					}.bind(this)
				}),
				
				afterClose: function() {
					this._mayUpdate = false;
					clearInterval(this._intervalId);
					this.fireClosed();
				}.bind(this)
			});
		},
		
		_updateContent : function() {
			$.ajax({
				type: "GET",
				url: "../" + this.getProperty("logFile"),
				dataType: 'text',
				cache: false,
				context: this,
				
				success: function (response) {
					this._oDialog.setTitle("Log: " + this.getProperty("logFile"));
					response = response.replace(/(?:\r\n|\r|\n)/g, '<br>');
					this._oDialog.getContent()[0].setHtmlText("<code>" + response + "</code>");
				},
				error: function (xhr, options, errorText) {
					this._oDialog.setTitle("Log: " + this.getProperty("logFile"));
					this._oDialog.getContent()[0].setHtmlText("<code>Log file '" + this.getProperty("logFile") + "' not found.</code>");
				}
			});
		},
		
		open : function() {
			this._oDialog.open();
			this._updateContent();
			
			var that = this;
			this._intervalId = setInterval(function() {
				that._updateContent();
			}, 5000);
		},

		renderer: function(oRenderManager, oControl) {
			return; /* nothing to render here */
		}
		
	});

	return LogViewer;
});