/* global sap jQuery util stopIntervals */
/* eslint-disable strict */

jQuery.sap.require("jquery.sap.history");
jQuery.sap.require("sap.m.InstanceManager");
jQuery.sap.require("util.Navigation");

sap.ui.controller("controllers.app", {

	getDefaultPage: function() {
		return util.Id.CATEGORIES;
	},

	onInit: function() {

		// subscribe to history changes
		var historyDefaultHandler = function(navType) {
			if (navType === jQuery.sap.history.NavType.Back) {
				this.navBack(this.getDefaultPage());
				return;
			} 
			
			var controlId = this._getControl2Load(window.location.hash);
			var writeHistory = (controlId === this.getDefaultPage()) ? false : true;
			
			this.navTo(controlId, null, writeHistory);
		};
		
		var historyPageHandler = function(params, navType) {
			if (!params || !params.id) {
				jQuery.sap.log.error("invalid parameter: " + params);
			} else {
				if (navType === jQuery.sap.history.NavType.Back) {
					this.navBack(params.id);
				} else {
					this.navTo(params.id, params.data, false);
				}
			}
		};
		
		jQuery.sap.history({
			routes: [
				{
					path: "page",
					handler: jQuery.proxy(historyPageHandler, this)
				}
			],
			defaultHandler: jQuery.proxy(historyDefaultHandler, this)
		});

		// subscribe to event bus
		var bus = sap.ui.getCore().getEventBus();
		bus.subscribe("nav", "to", this.navHandler, this);
		bus.subscribe("nav", "back", this.navHandler, this);
		bus.subscribe("nav", "virtual", this.navHandler, this);
	},

	navHandler: function(channelId, eventId, data) {
		stopIntervals();
		if (eventId === "to") {
			this.navTo(data.id, data.data, true);
		} else if (eventId === "back") {
			jQuery.sap.history.back();
		} else if (eventId === "virtual") {
			jQuery.sap.history.addVirtualHistory();
		} else {
			jQuery.sap.log.error("'nav' event cannot be processed. There's no handler registered for event with id: " + eventId);
		}
		if (data.doc) globalGuideInfo = data.doc;
	},

	navTo: function(id, data, writeHistory) {
		stopIntervals();
		if (id === undefined) {

			// invalid parameter
			jQuery.sap.log.error("navTo failed due to missing id");

		} else {

			// is it a master?
			// *AG* SP14: watch this frequently: dependency between code and file structure
			var master = !(id.indexOf("control.") === 0
				|| id.indexOf("dialogs.") === 0 || id.indexOf("type.") === 0
				|| id.indexOf("format.") === 0 || id.indexOf("sample.") === 0
				|| id.indexOf("utils.") === 0 || id.indexOf("charts.") === 0
				|| id.indexOf("docs.") === 0 || id.indexOf("slp.") === 0
				|| id.indexOf("sumui.") === 0);

			// load view on demand
			var app = this.getView().app;
			var view = app.getPage(id, master);
			if (!view) {
//				var type = (id === "code" || id === "controls") ? "XML" : "XML";
				var page = sap.ui.view({
					id: id,
					viewName: "views." + id,
					viewData: data,
					type: "XML"
				});
				if (master) {
					app.addMasterPage(page);
				} else {
					app.addDetailPage(page);
				}
				jQuery.sap.log.info("app controller > loaded page: " + id);
			}
			else if (data && !master) {
				view.oViewData = data;
				view.rerender();
			}
			else view.rerender();

			// navigate in the app control
			var transition = (!jQuery.device.is.phone && id.indexOf("control.") !== -1 && id.indexOf("type.") !== -1 && id.indexOf("format.") !== -1 && id.indexOf("sample.") !== -1) ? "show" : "slide";
			app.to(id, transition, data);

			// write browser history
			if ((writeHistory === undefined || writeHistory) && (jQuery.device.is.phone || master)) {
				jQuery.sap.history.addHistory("page", {
					id: id
				}, false);
			}

			// log
			jQuery.sap.log.info("navTo - to page: " + id + " [" + writeHistory + "]");
		}
	},

	navBack: function(id) {

		if (!id) {

			// invalid parameter
			jQuery.sap.log.error("navBack - parameters id must be given");

		} else {

			// close open popovers
			if (sap.m.InstanceManager.hasOpenPopover()) {
				sap.m.InstanceManager.closeAllPopovers();
			}

			// close open dialogs
			if (sap.m.InstanceManager.hasOpenDialog()) {
				sap.m.InstanceManager.closeAllDialogs();
				jQuery.sap.log.info("navBack - closed dialog(s)");
			}

			// ... and navigate back
			var app = this.getView().app;
			var currentId = (app.getCurrentPage()) ? app.getCurrentPage().getId() : null;
			if (currentId !== id) {
				app.backToPage(id);
				jQuery.sap.log.info("navBack - back to page: " + id);
			}
		}
	},
	
	_findControlIdByUrl : function(o, url) {
		if(o.url !== undefined && o.url === url) {
			return o.id;
		}
		
		var result; // = undefined
		var p; // = undefined
		
		for(p in o) {
			if(o.hasOwnProperty(p) && typeof o[p] === 'object') {
				result = this._findControlIdByUrl(o[p], url);
				if(result) { return result; }
			}
		}
		
		return result;
	},
	
	_getControl2Load : function(hashValue) {
		var id = this._findControlIdByUrl(util.Navigation, hashValue);
		return id !== undefined ? id : this.getDefaultPage();
	}
});
