/* global sap util jQuery */
/* eslint-disable strict, no-underscore-dangle */

sap.ui.controller("controllers.categories", {

	itemPress: function(evt) {
		var item = evt.getSource();
		sap.ui.getCore().getEventBus().publish("nav", "to", {
			id: util.Id.CONTROLS,
			data: {
				context: item.getBindingContext()
			}
		});
	},
	itemPress2: function(evt) {
		this._navigate(evt.getSource());
	},
	_navigate: function(item) {

		var model = sap.ui.getCore().getModel();
		var path = item.getBindingContext().getPath();
		var control = model.getProperty(path);

		// check theme support
		if (control.noMVI && util.ThemeDetection.isMVI()) {
			this._showThemeNotSupportedMsg("Mobile Visual Identity");
		} else if (control.noBC && util.ThemeDetection.isBC()) {
			this._showThemeNotSupportedMsg("Blue Crystal");
		} else {
			sap.ui.getCore().getEventBus().publish("nav", "to", {
				id: control.id,
				doc: (control.doc ? control.doc : null)
			});
		}
	},
	_showThemeNotSupportedMsg: function(themeName) {
		jQuery.sap.require("sap.m.MessageBox");
		sap.ui.getCore().getEventBus().publish("nav", "virtual");
		sap.m.MessageBox.alert("This control does not support the '" + themeName + "' theme", function(oAction) {
			if (oAction) {
				sap.ui.getCore().getEventBus().publish("nav", "back");
			}
		});
	}
});
