/* global sap jQuery util */
/* eslint-disable strict, no-undef, no-underscore-dangle, no-unused-vars, curly */

var plotBufLen = 100;
var plotData = [];
var lastTuple = 0;
var curGrphTmst = "";

sap.ui.controller("controllers.charts.controlCenter", {
	onInit: function(evt) {
		// get the page
		var view = this.getView();
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.CONTROL_CENTER);

		this.page.setBusy(true);

		view.addEventDelegate({
			onAfterShow: jQuery.proxy(function (evt) {
				this.onAfterShow(evt);
			}, this)
		});

		view.addEventDelegate({
			onExit: jQuery.proxy(function (evt) {
				this.onExit(evt);
			}, this)
		});

//		************* R3LOAD PROCESS MONITOR ******************************************************************

		var oModel = new sap.ui.model.xml.XMLModel();
		view.setModel(oModel, "R3LoadBuckets");

		// initialize filter and sort functions for R3LoadBucket table

		var oTable = view.byId("R3LoadBuckets");
		var oBinding = oTable.getBinding("rows");

		var aFilter = [];
		aFilter.push(new sap.ui.model.Filter("@export", function (oValue) { return handleFilter(oValue, true); }));
		aFilter.push(new sap.ui.model.Filter("@import", function (oValue) { return handleFilter(oValue, false); }));
		oBinding.filter(new sap.ui.model.Filter(aFilter, false));
		applyStatusSort(oBinding);

//		************* Slider & Limit init *********************************************************************
		this.sliderGrab = -1;					// initialize sliderGrab value to indicate that slider is currently not touched 
		this.graphInit = false;
		initProcessLimits(this.getView());
	},
	
	onExit: function(event) {
		autoUpdateModelR3LoadBuckets(this.getView(), false);
	},
	
	onAfterRendering: function() {
//		************* BUCKETS *********************************************************************************

//		Here, the R3Load process Data is loaded...
		updateModelR3LoadBuckets(this.getView());
		setFilter("finished", false);
	},

	/**
	 * Called after the page is shown
	 */
	onAfterShow: function(event) {

		function xmlToJson(xml) {
			// Create the return object
			var obj = {};
			if (xml.nodeType == 1) { // element, document
				// do attributes
				if (xml.attributes.length > 0) {
					obj["@attributes"] = {};
					for (var j = 0; j < xml.attributes.length; j++) {
						var attribute = xml.attributes.item(j);
						obj["@attributes"][attribute.nodeName] = attribute.nodeValue;
					}
				}
			} 
			else if (xml.nodeType == 3) obj = xml.nodeValue; // text
			// do children
			if (xml.hasChildNodes()) for (var i = 0; i < xml.childNodes.length; i++) {
				var item = xml.childNodes[i];
				var nodeName = item.nodeName;
				if (typeof (obj[nodeName]) == "undefined") obj[nodeName] = [];
				obj[nodeName].push(xmlToJson(item));                    
			}
			return obj;
		}
	
		function populateChart(chart, sliderGrabbed, updateInterval) {
			this.sliderGrabbed = sliderGrabbed;
			var locPage = view.byId("page");

			if (this.plotData === []) reqPar = "-"+this.plotBufLen;
			else reqPar = this.lastTuple;  
			$.ajax({
				dataType: "xml",
				type: 'GET',
				url: "../parallel_processes?xsl=0&load="+reqPar,
				cache: false,
				success: $.proxy(function(data) {
					try {
						var obj = xmlToJson(data.childNodes[0]);
						if (obj["@attributes"].id && obj["@attributes"].id!=this.curGrphTmst) {
							this.plotData = [];
							this.curGrphTmst = obj["@attributes"].id;
							this.lastTuple = 0;
							populateChart(chart, -1, updateInterval);
							return;
						}
						this.lastTuple = obj["@attributes"].lastpos;
					} catch (err) {
					}

					var tempdata = obj.load;
					if (tempdata!=undefined){
						var fifoOut = this.plotData.length+tempdata.length-this.plotBufLen;
						this.plotData = this.plotData.slice((fifoOut>0)?fifoOut:0);   
						for (var i = 0; i < tempdata.length; ++i) {
							this.plotData.push({"Time": tempdata[i]["@attributes"].timeoffset, "Proc": tempdata[i]["@attributes"].nrunning});
						}
					}
			        chart.setModel(new sap.ui.model.json.JSONModel(this.plotData));
			        
					locPage.setBusy(false);
					globalIntervals.controlCenterInterval = setTimeout(function(){populateChart(chart, this.sliderGrabbed, updateInterval);}, updateInterval);
				}, this),
				error: $.proxy(function (jqxhr, textStatus, error) {
					// no data yet, so we go on
					globalIntervals.controlCenterInterval = setTimeout(function(){populateChart(chart, this.sliderGrabbed, updateInterval);}, 10000);
				}, this)});
			// also update the R3Load Process Limit sliders
			if ((this.view) && (this.sliderGrabbed <= 0)) initProcessLimits(this.view);   
		}
	
		var view = this.getView();
		var chart = view.byId("R3loadPrcGrph");
        var dataset = {
    			dimensions : [{
    				name : 'Time',
    				value : "{Time}"
    			}],
    			measures : [{
    				name : 'nProcess',
    				value : '{Proc}'
    			}],
                data: {path: "/"}
            };
        chart.setModel(new sap.ui.model.json.JSONModel([]));
        var oDataset = new sap.viz.ui5.data.FlattenedDataset(dataset);
        chart.setDataset(oDataset);
        chart.setVizProperties( {
            plotArea: {
                dataLabel: {visible: true},
                window: {
                	start: {categoryAxis: {"Time": "firstDataPoint"}},
                	end: {categoryAxis: {"Time": "lastDataPoint"}}
                }
            },
			title: {visible: false},
			valueAxis: {
				title: {
					visible: true,
					text: "# Processes"
				}
			},
			categoryAxis: {
				axisTick: {visible: false},
				label: {visible: false}
			}
		});        
        populateChart(chart, this.sliderGrab, 2000);
		this.graphInit = true;
		if (!event) return;
		// BUCKETS
		// disable restart-Button since no Bucket yet selected
		setStatusRestartButton(view);
		// in case this page is called from the SLUIGUI-Notification-Button:
		// collapse all panels except the process bucket table
		if (window.location.hash === "#buckets") this.getView().byId("R3LoadProcesses").setExpanded(false);
	},
	handleSliderLiveChange: function(event) {		
		var ctrlId = event.getSource().getId();
		if (this.sliderGrab === -1) this.sliderGrab = getProcessLimit(); // if slider is touched just now, store the currprocesses value for later comparison
		var val = parseInt(event.getParameters().value);
		var tooltip = this.getView().byId("R3LoadSldLbl").getText() + ": " + val;
		this.getView().byId(event.getSource().getId().replace(ctrlId.slice(ctrlId.length-3), "Inp")).setValue(val).setTooltip(tooltip);
		event.getSource().setTooltip(tooltip);
	},
	handleSliderChange: function(event) {
		if (this.sliderGrab > -1) {
			setProcessLimits(this.getView(), parseInt(event.getParameters().value), this.sliderGrab);
			this.sliderGrab = -1;
		}
	},
	handleInputChange: function(event) {
		var cmd = event.getParameters().value;
		if (this.sliderGrab === -1) this.sliderGrab = getProcessLimit(); // store the currprocesses value for later comparison  
		switch (cmd) {
			case "stop": stopProcesses(false); break;
			case "kill": stopProcesses(true); break;
		}    
		var inp = parseInt(cmd);
		if (inp) {
			if (inp > upperLimPrc) {inp = upperLimPrc; cmd = inp.toString(); event.getSource().setValue(inp);}
			this.getView().byId(event.getSource().getId().replace("Inp", "Sld")).setValue(inp).fireChange({"value": inp});
		}
		if (inp || (cmd === "stop") || (cmd === "kill")) {
			var tooltip = this.getView().byId("R3LoadSldLbl").getText() + ": " + cmd;
			event.getSource().setTooltip(tooltip);
			this.getView().byId(event.getSource().getId().replace("Inp", "Sld")).setTooltip(tooltip);
		}
	},
	handleGraphExpand: function(event) {
		if (!this.graphInit) this.onAfterShow(null);
		this.handleR3LoadBucketsResize(event);
	},
	handleR3LoadBucketsSelect: function(event) {
		// triggered each time a row is selected
		var oTable = this.getView().byId("R3LoadBuckets");
		oTable.getSelectedIndices().forEach(function (selectedIdx) {
			var cxt = oTable.getContextByIndex(selectedIdx);
			var bucketImpStat = oTable.getModel("R3LoadBuckets").getProperty(cxt.sPath + "/@import");
			var bucketExpStat = oTable.getModel("R3LoadBuckets").getProperty(cxt.sPath + "/@export");
			if ((bucketImpStat === 'failed') || (bucketImpStat === 'killed') || (bucketExpStat === 'failed') || (bucketExpStat === 'killed')) {
				// everything is OK
			} else {
				oTable.removeSelectionInterval(selectedIdx, selectedIdx);
			}
		});
		// update restart Button status because it could be that no row is
		// selected
		setStatusRestartButton(this.getView());
	},
	handleR3LoadBucketsExpand: function(event) {
		// expand or collapse the panel - button status must be adjusted
		this.getView().byId("R3LoadBucketsRefresh").setEnabled(event.getParameters().expand);
		this.getView().byId("R3LoadBucketsAutoRefresh").setEnabled(event.getParameters().expand);
		if (event.getParameters().expand) {
			setStatusRestartButton(this.getView());
		} else {
			this.getView().byId("R3LoadBucketsRestart").setEnabled(false);
			this.getView().byId("R3LoadBucketsAutoRefresh").setPressed(false);
		}
	},
	handleR3LoadBucketsResize: function(event) {
		// my intention was that the R3Load Process panel adjusts its size each time
		// the other panels are expanded/collapsed
		var panelId = event.getSource().getId();
		this.getView().byId("page").rerender();
	},
	handleR3LoadBucketsRefresh: function() {
		// refresh the table
		updateModelR3LoadBuckets(this.getView());
	},
	handleR3LoadBucketsAutoRefresh: function(event) {
		// refresh the table
		autoUpdateModelR3LoadBuckets(this.getView(), event.getSource().getPressed());
	},
	handleR3LoadBucketsRestart: function() {
		// triggered when the restart button is pressed
		var view = this.getView();
		var table = view.byId("R3LoadBuckets");
		var bucketRefs = table.getSelectedIndices();
		var bucketRefIds = new Array();
		// filter out which buckets are valid for a restart
		bucketRefs.forEach(function (bucketRef) {
			var cxt = table.getContextByIndex(bucketRef);
			var bucketImpStat = table.getModel("R3LoadBuckets").getProperty(cxt.sPath + "/@import");
			var bucketExpStat = table.getModel("R3LoadBuckets").getProperty(cxt.sPath + "/@export");
			if ((bucketImpStat === 'failed') || (bucketImpStat === 'killed') || (bucketExpStat === 'failed') || (bucketExpStat === 'killed')) {
				var bucketRefId = table.getModel("R3LoadBuckets").getProperty(cxt.sPath + "/@refid");
				bucketRefIds.push(bucketRefId);
			}
		});
		var numBuckets = bucketRefIds.length;
		if (numBuckets > 0) {
			restartR3LoadBucket(bucketRefIds, view);
		}
		// remove the row selections
		table.removeSelectionInterval(0, table.getBinding().getLength());
		updateModelR3LoadBuckets(view);
	},
	handleR3LoadBucketLog: function(oEvent) {
		// triggered each time an icon for the log has been clicked
		var logFile = oEvent.getSource().data("logfile");
		$.ajax({
			type: "GET",
			url: "../load/" + logFile,
			dataType: 'text',
			cache: false,
			success: function (response)
			{
				var oDialog1 = new sap.m.Dialog({
					title:			"Log: " + logFile,
					resizable: 		true,
					draggable:		true,
					contentWidth: 	"800px",
					contentHeight:	"600px",
					endButton: 		new sap.m.Button({text: "Close", press: closeDialog})
				});
				oDialog1.addStyleClass("sapUiSizeCompact");
				
				this.logArea = new sap.m.Text({text: response});
				var logBox = new sap.m.VBox({fitContainer: true, items: [this.logArea]});
				logBox.addStyleClass("sapUiSmallMargin");
				oDialog1.addContent(logBox);
				oDialog1.open();
			},
			error: function(xhr, options, errorText)
			{
				sap.m.MessageToast.show(xhr.statusText + ": " + xhr.responseText);
				// alert('Error: ' + errorText + ' ' + xhr.status);
			}
		});
	},
	handleFilterToggle: function(event) {
		// triggered when any of the filter buttons is pressed on or off;
		var buttonId = event.getSource().getId();
		var idPos = buttonId.lastIndexOf("--") + 2;
		setFilter(buttonId.substr(idPos, buttonId.length - idPos), event.getSource().getPressed());
		this.getView().byId("R3LoadBuckets").getBinding("rows").refresh(true);
	},
	colorR3LoadBucketProc: function(state) {
		// formatter routine determining the color of the Logfile Icons
		return (state === 'finished') ? ((document.URL.indexOf("?suihcw=true")>0) ? "seagreen" : "lightgreen") : (state === 'running') ? ((document.URL.indexOf("?suihcb=true")>0) ? "white" : "black") : ((state === null) || (state === 'rescheduled') || (state === 'terminateded') || (state === 'restarting')) ? "lightgrey" : "red";
	},
	iconR3LoadBucketProcLog: function(state) {
		// formatter routine determining the Logfile Icons
		return ((state === null) || (state === 'rescheduled') || (state === 'terminated') || (state === 'restarting')) ? "sap-icon://hide" : "sap-icon://inspection";
	},
	iconR3LoadBucketProcLogTT: function(state) {
		// formatter routine determining the tooltip text for the Logfile Icons
		return ((state === null) || (state === 'rescheduled') || (state === 'terminated') || (state === 'restarting')) ? "No Log available" : "Show Log";
	},
	resultR3LoadBuckets: function(sExp, sImp) {        
		// formatter routine determining the visualized common result status of the bucket
		return (((sImp === null) || (sImp === 'finished')) && ((sExp === null) || (sExp === 'finished'))) ? "Finished" : ((sImp === 'running') || (sExp === 'running')) ? "Running" : ((sImp !== 'failed') && (sExp !== 'failed') && (sImp !== 'killed') && (sExp !== 'killed')) ? "Rescheduled" : "Error";
	},
	statusR3LoadBuckets: function(sExp, sImp) {
		// formatter routine determining the ObjectStatus of the bucket (for the display color)
		return (((sImp === null) || (sImp === 'finished')) && ((sExp === null) || (sExp === 'finished'))) ? "Success" : ((sImp !== 'failed') && (sExp !== 'failed') && (sImp !== 'killed') && (sExp !== 'killed')) ? "None" : "Error";
	},
	iconR3LoadBuckets: function(sExp, sImp) {
		// formatter routine determining the ObjectStatus Icon
		var map = {"Success": "sap-icon://status-completed", "None": "sap-icon://media-play", "Error": "sap-icon://message-error"};
		return map[this.statusR3LoadBuckets(sExp, sImp)];
	},
	handleColumnSelect: function(event) {
		// triggered whenever a column header is clicked (for changing the sort
		// order)
		var colId = event.getParameters().column.getId();
		// only column 'Status' needs to be handled explicitly here, column 'Ref
		// Id' benefits from core functionality
		if (colId === "charts.controlCenter--colStatus") {
			var oTable = this.getView().byId("R3LoadBuckets");
			var oBinding = oTable.getBinding("rows");
			applyStatusSort(oBinding);
			// indicate new sort order with respective symbol in column header
			this.getView().byId(colId).setSorted(true);
			this.getView().byId("charts.controlCenter--colId").setSorted(false);
		}
	},
	summaryLine: function() {
		// formatter routine composing summary line
		return composeBucketSummary();
	}    	
});
