
sap.ui.controller("controllers.charts.crrCenter", {
    onInit: function(evt) {
        var that = this;
        var view = this.getView();
        
        this.page = view.byId("page");
        util.UiFactory.fillPageHeader(this.page, view, "Change Recording & Replay Control Center");
        
        /* Overview CRR status */
        that.oCrrAbap   = view.byId("oCrrAbap");
        that.oCrrR3load = view.byId("oCrrR3load");
        
        that.oAbapTile     = view.byId("oAbapTile");
        that.oR3loadTile = view.byId("oR3loadTile");
        
        that.oReadyForDT        = view.byId("oReadyForDT");
        that.oTotalCrrOverview  = view.byId("oTotalCrrOverview");
        that.oAbapCrrOverview   = view.byId("oAbapCrrOverview");
        that.oR3loadCrrOverview = view.byId("oR3loadCrrOverview");
        that.oRecordedOverview  = view.byId("oRecordedOverview");
        that.oReplayedOverview  = view.byId("oReplayedOverview");
        that.oPendingOverview   = view.byId("oPendingOverview");
        
        that._setReadyForDT(false);
        that._setCRRStatusOverview(that.oTotalCrrOverview, -1);
        that._setCRRStatusOverview(that.oAbapCrrOverview, -1);
        that._setCRRStatusOverview(that.oR3loadCrrOverview, -1);
        
        that._setCRRChangesOverview(that.oRecordedOverview, -1);
        that._setCRRChangesOverview(that.oReplayedOverview, -1);
        that._setCRRChangesOverview(that.oPendingOverview, -1);
        
        that.oCrrAbap.doUpdate();
        that.oCrrR3load.doUpdate();
        that._updateCRRStatusOverview();
        
        this._intervalId = setInterval(function() {
            that.oCrrAbap.doUpdate();
            that.oCrrR3load.doUpdate();
            that._updateCRRStatusOverview();
        }, 5000);
    },
    
    onExit : function(oEvent) {
        clearInterval(this._intervalId);
        this.page.destroy();
        delete this.page;
    },
    
    /* ****************************************************************** */
    
    _setReadyForDT : function(isReady) {
        this.oReadyForDT.setText(isReady === true ? "YES" : "NO");
        this.oReadyForDT.setState(isReady === true ? "Success" : "Error");
    },
    
    _setCRRStatusOverview : function(obj, val) {
        var color = sap.m.ValueColor.Neutral;
        
        val = parseInt(val);
        
        if(val < 40) {
            color = sap.m.ValueColor.Error;
        } else if(val < 90) {
            color = sap.m.ValueColor.Critical;
        } else {
            color = sap.m.ValueColor.Good;
        }
        
        if(val >= 0) {
            obj.setValue(val.toString() + "%");
        } else {
            obj.setValue("?");
        }
        
        obj.setValueColor(color);
    },
    
    _setCRRChangesOverview : function(obj, val) {
        val = parseInt(val);
        
        if(val < 0) {
            obj.setValue("?");
            obj.setValueColor(sap.m.ValueColor.Critical);
        } else {
            
            if(val > 1000000) {
                val = parseFloat(val/1000000).toFixed(1).toString() + "M";
            } else if(val > 1000) {
                val = parseFloat(val/1000).toFixed(1).toString() + "k";
            } else {
                val = val.toString();
            }
            
            obj.setValue(val);
            obj.setValueColor(sap.m.ValueColor.Neutral);
        }
    },
    
    /* ****************************************************************** */
    
    _updateCRRStatusOverview : function() {
        
        var isAbapRegistered = this.oCrrAbap.getRegistered();
        var isR3loadRegistered = this.oCrrR3load.getRegistered();
        
        var isReadyABAP = this.oCrrAbap.getReadyForDowntime();
        var isReadyR3load = this.oCrrR3load.getReadyForDowntime();
        
        var showBoth = true;
        if(isAbapRegistered === false || isR3loadRegistered === false) {
            showBoth = false;
        }
        
        this.oAbapTile.setVisible(showBoth);
        this.oR3loadTile.setVisible(showBoth);
        
        /* ******************************************** */
        var crrRateTotal = -1;
        var crrRateAbap = this.oCrrAbap.getTotalCrrRate();
        var crrRateR3load = this.oCrrR3load.getTotalCrrRate();
        
        /* ******************************************** */
        var sumReplayed = 0;
        var sumPending  = 0;
        var sumRecorded = 0;
        
        if(isAbapRegistered === true) {
            sumReplayed = sumReplayed + this.oCrrAbap.getSumCrrReplayed();
            sumRecorded = sumRecorded + this.oCrrAbap.getSumCrrRecorded();
            sumPending  = sumPending  + this.oCrrAbap.getSumCrrPending();
        }
        
        if(isR3loadRegistered === true) {
            sumReplayed = sumReplayed + this.oCrrR3load.getSumCrrReplayed();
            sumRecorded = sumRecorded + this.oCrrR3load.getSumCrrRecorded();
            sumPending  = sumPending  + this.oCrrR3load.getSumCrrPending();
        }
        
        /* ******************************************** */
        if(showBoth === true)
        {
            if(sumRecorded > 0 && crrRateR3load > 0 && crrRateAbap > 0) {
                crrRateTotal = (100./sumRecorded) * sumReplayed;
            }
        }
        else if(isAbapRegistered === true)
        {
            crrRateTotal = crrRateAbap;
        }
        else if(isR3loadRegistered === true)
        {
            crrRateTotal = crrRateR3load;
        }

        if(crrRateTotal > 99 && sumPending > 0) {
            crrRateTotal = 99;
        }
       
        /* ******************************************** */
        this._setReadyForDT(crrRateTotal >= 75 && isReadyABAP === true && isReadyR3load === true ? true : false);
        this._setCRRStatusOverview(this.oAbapCrrOverview, crrRateAbap >= 0 ? crrRateAbap : -1);
        this._setCRRStatusOverview(this.oR3loadCrrOverview, crrRateR3load >= 0 ? crrRateR3load : -1);
        this._setCRRStatusOverview(this.oTotalCrrOverview, crrRateTotal >= 0 ? crrRateTotal : -1);
        
        this._setCRRChangesOverview(this.oRecordedOverview, sumRecorded);
        this._setCRRChangesOverview(this.oReplayedOverview, sumReplayed);
        this._setCRRChangesOverview(this.oPendingOverview, sumPending);
    }
});
