sap.ui.define([
        "sap/ui/core/mvc/Controller",
        "SUMControls/LogViewer"
], function (Controller, LogViewer) {
	"use strict";
	
    return Controller.extend("controllers.charts.daemonCenter", {

		onInit : function() {
			var view = this.getView();
			
			this.page = view.byId("page");
			util.UiFactory.fillPageHeader(this.page, view, util.Title.DAEMON_CENTER);
			
			this.oModel = new sap.ui.model.json.JSONModel();
			this._populateTable();
			
			this.canUpdateTable = true;
			
			var that = this;
			this._intervalId = setInterval(function() {
				if(that.canUpdateTable) {
					that._populateTable();
				}
			}, 5000);
		},
		
		onExit : function(oEvent) {
			clearInterval(this._intervalId);
		},
		
		/* ****************************************************************** */
		
		onStart : function(oEvent) {
			this.canUpdateTable = false;
			var daemon = this._getSelectedRowModel(oEvent);
			var content='<SAPup type="daemon"><Daemon name="' + daemon.name + '" request="START" /></SAPup>';
			this._postDaemonAction(content);
		},
		
		onStop : function(oEvent) {
			this.canUpdateTable = false;
			var daemon = this._getSelectedRowModel(oEvent);
			var content='<SAPup type="daemon"><Daemon name="' + daemon.name + '" request="STOP" /></SAPup>';
			this._postDaemonAction(content);
		},
		
		onKill : function(oEvent) {
			this.canUpdateTable = false;
			var daemon = this._getSelectedRowModel(oEvent);
			var content='<SAPup type="daemon"><Daemon name="' + daemon.name + '" request="KILL" /></SAPup>';
			this._postDaemonAction(content);
		},
		
		/* ****************************************************************** */
		
		_getSelectedRowModel : function(oEvent) {
			var path = oEvent.getSource().getBindingContext().getPath();
			return this.oModel.getProperty(path);
		},
		
		_postDaemonAction : function(content) {
			this._success = function(data, that) {
				that._populateTable();
				that.canUpdateTable = true;
			};
			
			doPost(function(data){this._success(data, this);}, function(){this._success(null, this);}, "../daemons?xsl=0", content, this);
			
/*			$.ajax({
				url: "../daemons?xsl=0",
				type: "POST",
				dataType: "text",
				context: this,
				data: content,
				
				error: function() {
					this._success(null, this);
				},
				
				success: function(data) {
					this._success(data, this);
				}
			}); 
*/
		},
	
		/* ****************************************************************** */
		
		_populateTable : function() {
			this.view = this.getView();
			
			this._getXmlNode = function(data, that) {
				var xmlNode = $("Daemons", data);
				
				var daemons = xmlNode.find("Daemon");
				var lendaemons = daemons.length;
				
				var modelData = {};
				modelData.data = [];
				
				for(var i = 0 ; i < lendaemons ; i++) {
					var daemonNode = daemons[i];
					
					var daemon = {};
					daemon.pid         = UIGetAttribute(daemonNode, "pid", -1);
					daemon.name        = UIGetAttribute(daemonNode, "name", "");
					daemon.status      = UIGetAttribute(daemonNode, "status", "");
					daemon.request     = UIGetAttribute(daemonNode, "request", "");
					daemon.description = UIGetAttribute(daemonNode, "message", "");
					daemon.type        = UIGetAttribute(daemonNode, "type", "");
					daemon.logfile     = UIGetAttribute(daemonNode, "logfile", null);
					
					daemon.showLogFile = false;
					if(daemon.logfile !== null) {
						daemon.showLogFile = true;
					}
					
					daemon.visibleStop = true;
					daemon.visibleKill = true;
					
					UISetDaemonProcessStatus(daemon);
					modelData.data.push(daemon);
				}
				
				that.oModel.setData(modelData);
				
				var oTable = that.view.byId("idDaemonsTable");
				oTable.setModel(that.oModel);
			};
			
			$.ajax({
				url: "../daemons?xsl=0",
				type: "GET",
				dataType: "xml",
				cache: false,
				context: this,
	
				error: function() {
					this._getXmlNode(null, this.that);
				},
				
				success: function(data) {
					this._getXmlNode(data, this);
				}
			});
		},
	
		/* ****************************************************** */
		
		_openLogViewer : function(logFilePath) {
			this._oLogViewer = new LogViewer({ 
										logFile: logFilePath,
										closed : function() {
											this._oLogViewer.destroy();
										}.bind(this)
								});
			this._oLogViewer.open();
		},
		
		/* ****************************************************** */
		
		onLogFile : function(oEvent) {
			var daemon = this._getSelectedRowModel(oEvent);
			if(daemon.logfile === null) { return; }
			this._openLogViewer("log/" + daemon.logfile);
		}
    });
});
