sap.ui.controller("controllers.charts.dbStatistics", {

	onInit: function() {
		var view = this.getView();

		this.page = view.byId("page");
        util.UiFactory.fillPageHeader(this.page, view, util.Title.DB_STATISTICS);

        this.oChart = view.byId("oChart");
        this.oTypeSelector = view.byId("oTypeSelector");

        this.oData = {};
		this._readCSV();
	},

	onExit: function() {
		this.page.destroy();
		delete this.page;
	},

    // ---------------------------------------------------------------------

    _prepareCPUChart : function() {
        this.oChart.setVizType("line");
        this.oChart.setDataset(new sap.viz.ui5.data.FlattenedDataset({
            dimensions : [ {
                name : "Time",
                value : "{time}"
            }],
            measures : [{
                name : "CPU Usage",
                value : "{cpu}"
            }],
            data : {
                path : "/data"
            }
        }));
        this.oChart.removeAllFeeds();
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
          "uid": "valueAxis",
          "type": "Measure",
          "values": ["CPU Usage"]
        }));
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
              "uid": "categoryAxis",
              "type": "Dimension",
              "values": ["Time"]
        }));
        this.oChart.setVizProperties({
            title: {
                visible: true,
                text: "CPU Usage of SAP HANA Database"
            },
            valueAxis : {
                title : {
                    visible : true,
                    text : "CPU Usage (in %)"
                }
            },
            plotArea: {
                marker: {
                    visible: false
                }
            }
        });
    },

    // ---------------------------------------------------------------------

    _prepareMemoryChart : function() {
        this.oChart.setVizType("line");
        this.oChart.setDataset(new sap.viz.ui5.data.FlattenedDataset({
            dimensions : [{
                name : "Time",
                value : "{time}"
            }],
            measures : [{
                name : "Used Memory",
                value : "{usedMemory}"
            }, {
                name: "Maximum Memory",
                value: "{maxMemory}"
            }],
            data : {
                path : "/data"
            }
        }));
        this.oChart.removeAllFeeds();
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
          "uid": "valueAxis",
          "type": "Measure",
          "values": ["Used Memory", "Maximum Memory"]
        }));
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
              "uid": "categoryAxis",
              "type": "Dimension",
              "values": ["Time"]
        }));
        this.oChart.setVizProperties({
            title: {
                visible: true,
                text: "Memory Usage of SAP HANA Database"
            },
            valueAxis : {
                title : {
                    visible : true,
                    text : "Memory Usage (in MB)"
                }
            },
            plotArea: {
                marker: {
                    visible: false
                }
            },
        });
    },

    // ---------------------------------------------------------------------

    _prepareDiskChart : function() {
        this.oChart.setVizType("line");
        this.oChart.setDataset(new sap.viz.ui5.data.FlattenedDataset({
            dimensions : [{
                name : "Time",
                value : "{time}"
            }],
            measures : [{
                name : "Disk Used",
                value : "{diskUsed}"
            }, {
                name: "Disk Size",
                value: "{diskSize}"
            }],
            data : {
                path : "/data"
            }
        }));
        this.oChart.removeAllFeeds();
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
          "uid": "valueAxis",
          "type": "Measure",
          "values": ["Disk Used", "Disk Size"]
        }));
        this.oChart.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
              "uid": "categoryAxis",
              "type": "Dimension",
              "values": ["Time"]
        }));
        this.oChart.setVizProperties({
            title: {
                visible: true,
                text: "Disk Usage of SAP HANA Database"
            },
            valueAxis : {
                title : {
                    visible : true,
                    text : "Disk Usage (in MB)"
                }
            },
            plotArea: {
                marker: {
                    visible: false
                }
            }
        });
    },

    // ---------------------------------------------------------------------

    onReloadChart : function() {
        var item = this.oTypeSelector.getSelectedItem();

        if(item === null) {
            item = this.oTypeSelector.getFirstItem();
        }

        if(item === null) {
            return;
        }

        this.oChart.setBusy(true);
        this.oTypeSelector.setEnabled(false);

        if(item.getKey() === "0") {
            this._prepareCPUChart();
        } else if(item.getKey() === "1") {
            this._prepareMemoryChart();
        } else if(item.getKey() === "2") {
            this._prepareDiskChart();
        }

        var model = new sap.ui.model.json.JSONModel();
        model.setData(this.oData);

        this.oChart.setModel(model);
    },

    // ---------------------------------------------------------------------

    onRenderComplete : function(event) {
        this.oChart.setBusy(false);
        this.oTypeSelector.setEnabled(true);
    },

    // ---------------------------------------------------------------------

    _readCSV : function() {
        this.oData = {};
        this.oData.data = [];

        this.oChart.setBusy(true);
        this.oTypeSelector.setEnabled(false);

        var readLineByLine = function(data, that) {
            if(data != null) {
                that.oData.data.push({
                    "host": data[0],
                    "time": data[7] + " | " + that._getTimeStamp(data[1]),
                    "usedMemory": data[2],
                    "maxMemory": data[3],
                    "cpu": data[4],
                    "diskUsed": data[5],
                    "diskSize": data[6],
                    "phase": data[7]
                });
            } else {
                that.onReloadChart();
            }
        };

        UIReadCSVFile("../doc/analysis/HDBMONITOR.CSV", readLineByLine, this);
    },

    // ---------------------------------------------------------------------

    _getTimeStamp : function(timestamp) {
        return timestamp.split(".")[0];
    }
});
