var CLONEEVALUATION_TAG = "CloneEvaluation";
var CLONEBUCKET_TAG = "CloneBucket";
var CPUTIME_TAG = "CpuTime";
var CLONETABLE_TAG = "CloneTable";

var oModel;
var oAggregatedModel;

//datasets for db imp/exp, duration, tables and rows
var dbDataSet;
var durationDataSet;
var tableDataSet;
var rowDataSet;
var membuffDataSet;
var memdiskDataSet;
//related feeditems
var bucketValueAxis;
var bucketCategoryAxis;
var dbValueAxis;
var dbCategoryAxis;

var popupCPUTimesView;
var popupTablesView;

sap.ui.define([
        'jquery.sap.global',
        'sap/ui/core/mvc/Controller',
        'sap/ui/model/json/JSONModel',
        'sap/viz/ui5/data/FlattenedDataset'
    ], function(jQuery, Controller, JSONModel, FlattenedDataset, CustomerFormat, InitPageUtil) {
    "use strict";
    
    var Controller = Controller.extend("controllers.charts.dmoBucViewer",
    {
        onInit : function ()
        {
            var that = this;
            var view = this.getView();
            
            this.page = view.byId("page");
            util.UiFactory.fillPageHeader(this.page, view, util.Title.DMO_BUC_VIEWER);
    
            var oVizFrame = view.byId("bucketChart");
            oVizFrame.setBusy(true);
    
            this._setDatasets();
            this._setFeedItems();
            
            oVizFrame.setDataset(dbDataSet);
            oVizFrame.addFeed(dbValueAxis);
            oVizFrame.addFeed(dbCategoryAxis);
            oVizFrame.setVizProperties({
                title: {
                    visible: true,
                    text: 'Realtime of DB Export/Import per Bucket'
                },
                valueAxis : {
                    title : {
                        visible : true,
                        text : "Realtime (in sec)"
                    }
                }
            });
            var vizPopover = new sap.viz.ui5.controls.Popover({});
            vizPopover.connect(oVizFrame.getVizUid());
            
            var fileModel = new sap.ui.model.json.JSONModel("controllers/charts/dmoFiles.json");
            view.setModel(fileModel, "allFiles");
            
            var finalCallback = function(that) {
                that.fnUpdateChart();
            };
            
            UIGetFilesFromJsonAdd2Selector("controllers/charts/dmoFiles.json", 
                                           "BucketViewer", view.byId("fileSelector"),
                                           finalCallback, this);
            
            // create dialog via fragment factory
            if(!this._oDialog) {
                this._oDialog = sap.ui.xmlfragment("views.charts.dmoBucViewer", this);
                // connect dialog to view (models, lifecycle)
                this.getView().addDependent(this._oDialog);
            }
        },
        
        onExit: function()
        {
            this.page.destroy();
            delete this.page;
        },
        
        /* ***************************************************************** */
        /*    UPDATE CHART
        /* ***************************************************************** */
        fnUpdateChart : function(oControlEvent)
        {
            var that = this;
            var view = this.getView();
            
            var oSelect = view.byId("fileSelector");
            var item = oSelect.getSelectedItem();
            
            if(item == null) {
                item = oSelect.getFirstItem();
            }
            if(item == null) {
                return;
            }
            
            var oVizFrame = view.byId("bucketChart");
            oVizFrame.setBusy(true);
            
            that._parseXML(item.getKey());
        },
        
        fnRenderComplete : function(oControlEvent)
        {
            var view = this.getView();
            var oVizFrame = view.byId("bucketChart");
            oVizFrame.setBusy(false);
        },
        
        _parseXML : function(filePath)
        {
            var that = this;
            
            $.ajax({
                url: filePath + "?" + Math.random(),
                dataType: 'xml',
                success: function(data){
                    // Extract relevant data from XML
                    var xml_node = $(CLONEEVALUATION_TAG, data);
                    var oData = [];
                    var clonebuckets = xml_node.find(CLONEBUCKET_TAG);
                    for(var i = 0 ; i < clonebuckets.length ; i++)
                    {
                        var xmlCloneBucket = clonebuckets[i];
    
                        var clonebucket = {
                           "id" : UIGetAttribute(xmlCloneBucket, "id", 0),
                           "dbimp_dbexp" : UIGetAttribute(xmlCloneBucket, "dbimp_dbexp", 0),
                           "exp" : null,
                           "imp" : null
                        };
                        
                        // Parse Export Node
                        $(xmlCloneBucket).find("Export").each(function() {
                            clonebucket.exp = that._parseMode($(this), "EXP");
                        });
                        
                        // Parse Import Node
                        $(xmlCloneBucket).find("Import").each( function() {
                            clonebucket.imp = that._parseMode($(this), "IMP");
                        });
                        
                        // Aggregated bucket
                        if(clonebucket.id == 0) {
                            oAggregatedModel = that._genBucketModel([clonebucket]);
                        }
                        else {
                            oData.push(clonebucket);
                        }
                    }
                    
                    that._addGraph(oData);
                },
                error: function(data){
                }
            });
        },
    
        /**
         * parse the mode of a clone bucket
         * @param xmlMode Clone Bucket as XML Element
         * @returns parsed mode
         */
        _parseMode : function(xmlMode, suffix)
        {
            var that = this;
    
            var dbCPUTimes = null;
            var dbGENERALTimes = null;
    
            // Parse CPU times        
            $(xmlMode).find(CPUTIME_TAG).each(function()
            {
                var xmlCPUTime = $(this);
                var type = UIGetAttribute(xmlCPUTime, "type", "");
                
                if(type === "DB")
                {
                    dbCPUTimes = that._genCPUTime("DB",
                                                  UIGetAttribute(xmlCPUTime, "realtime", 0),
                                                  UIGetAttribute(xmlCPUTime, "usrtime", 0),
                                                  UIGetAttribute(xmlCPUTime, "systime", 0));
                }
                else if(type === "GENERAL")
                {
                    dbGENERALTimes = that._genCPUTime("GENERAL",
                                                      UIGetAttribute(xmlCPUTime, "realtime", 0),
                                                      UIGetAttribute(xmlCPUTime, "usrtime", 0),
                                                      UIGetAttribute(xmlCPUTime, "systime", 0));
                }
            });
            
            // Parse tables
            var tables = [];
            $(xmlMode).find(CLONETABLE_TAG).each(function()
            {
                var clonetable = $(this);
                tables.push({ "type"     : suffix,
                              "name"     : UIGetAttribute(clonetable, "name", ""),
                              "cntrows"  : UIGetAttribute(clonetable, "cntrows", 0),
                              "duration" : UIGetAttribute(clonetable, "cntrows", 0) });
            });
            
            return {
                "mode"            : suffix,
                "cnttables"       : UIGetAttribute(xmlMode, "cnttables", 0),
                "cntrows"         : UIGetAttribute(xmlMode, "cntrows", 0),
                "duration"        : UIGetAttribute(xmlMode, "duration", 0),
                "memusage_buffer" : UIGetAttribute(xmlMode, "memusage_buffer", 0),
                "memusage_disk"   : UIGetAttribute(xmlMode, "memusage_disk", 0),
                "cputimes"        : {
                    "db"      : dbCPUTimes,
                    "general" : dbGENERALTimes
                },
                "tables"          : tables
            };
        },
        
        _addGraph : function(oData)
        {
            this.getView().byId("dataSelector").setEnabled(true);
            var oVizFrame = this.getView().byId("bucketChart");
            
            this._setDatasets();
            oModel = this._genBucketModel(oData);
            
            oVizFrame.setModel(oModel);
            this._createCpuTimeCharts(0, "Aggregated", oAggregatedModel);
        },
        
        _genBucketModel : function(oData)
        {
            var model = new sap.ui.model.json.JSONModel();
            model.setData({ buckets: oData });
            return model;
        },
        
        /**
         * method to handle changing the value of the chart container selector
         * changes the dataset
         * @param oEvent triggered event
         */
        changeValues : function(oEvent)
        {
            var oItem = oEvent.getParameter("selectedItem");
            var oVizFrame = this.getView().byId("bucketChart");
            
            oVizFrame.setBusy(true);
            
            if (oItem.getKey() === "0") {
                oVizFrame.setVizType("column");
                oVizFrame.setDataset(durationDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(bucketValueAxis);
                oVizFrame.addFeed(bucketCategoryAxis);
                oVizFrame.setVizProperties({
                    title: {
                        visible: true,
                        text: 'Duration per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Time (in sec)"
                        }
                    }
                });
            }
            else if(oItem.getKey() === "1") {
                oVizFrame.setVizType("column");
                oVizFrame.setDataset(tableDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(bucketValueAxis);
                oVizFrame.addFeed(bucketCategoryAxis);
                oVizFrame.setVizProperties({
                    title: {
                        visible: true,
                        text: 'Number of Tables per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Number of Tables"
                        }
                    }
                });
            }
            else if(oItem.getKey() === "2") {
                oVizFrame.setVizType("column");
                oVizFrame.setDataset(rowDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(bucketValueAxis);
                oVizFrame.addFeed(bucketCategoryAxis);
                oVizFrame.setVizProperties({
                    title: {
                        visible: true,
                        text: 'Number of Rows per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Number of Rows"
                        }
                    }
                });
            }
            else if(oItem.getKey() === "3") {
                oVizFrame.setVizType("stacked_column");
                oVizFrame.setDataset(dbDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(dbValueAxis);
                oVizFrame.addFeed(dbCategoryAxis);
                oVizFrame.setVizProperties( {
                    title: {
                        visible: true,
                        text: 'Realtime of DB Export/Import per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Realtime (in sec)"
                        }
                    }
                });
            }
            else if(oItem.getKey() === "4") {
                oVizFrame.setVizType("column");
                oVizFrame.setDataset(membuffDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(bucketValueAxis);
                oVizFrame.addFeed(bucketCategoryAxis);
                oVizFrame.setVizProperties( {
                    title: {
                        visible: true,
                        text: 'Buffer Memory Usage per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Memory Usage (in MB)"
                        }
                    }
                });
            }
            else if(oItem.getKey() === "5") {
                oVizFrame.setVizType("column");
                oVizFrame.setDataset(memdiskDataSet);
                oVizFrame.removeAllFeeds();
                oVizFrame.addFeed(bucketValueAxis);
                oVizFrame.addFeed(bucketCategoryAxis);
                oVizFrame.setVizProperties( {
                    title: {
                        visible: true,
                        text: 'Disk Memory Usage per Bucket'
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Memory Usage (in MB)"
                        }
                    }
                });
            }
        },
        
        /**
         * set static datasets used in chart
         */
        _setDatasets : function()
        {
            /**
             * static data sets to select later
             */
            dbDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/cputimes/db/realtime}'
                },{
                    name : 'Import',
                    value : '{imp/cputimes/db/negrealtime}'
                }],
                data : {
                    path : "/buckets"
                }
            });
            durationDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/duration}'
                }, {
                    name : 'Import',
                    value : '{imp/duration}'
                } ],
                data : {
                    path : "/buckets"
                }
            });
            tableDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/cnttables}'
                }, {
                    name : 'Import',
                    value : '{imp/cnttables}'
                } ],
                data : {
                    path : "/buckets"
                }
            });
            rowDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/cntrows}'
                }, {
                    name : 'Import',
                    value : '{imp/cntrows}'
                } ],
                data : {
                    path : "/buckets"
                }
            });
            membuffDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/memusage_buffer}'
                }, {
                    name : 'Import',
                    value : '{imp/memusage_buffer}'
                } ],
                data : {
                    path : "/buckets"
                }
            });
            memdiskDataSet = new sap.viz.ui5.data.FlattenedDataset({
                dimensions : [ {
                    name : 'Bucket ID',
                    value : "{id}"
                } ],
                measures : [ {
                    name : 'Export',
                    value : '{exp/memusage_disk}'
                }, {
                    name : 'Import',
                    value : '{imp/memusage_disk}'
                } ],
                data : {
                    path : "/buckets"
                }
            });
        },
        
        /**
         * set static feeditems used in chart
         */
        _setFeedItems : function()
        {
            bucketValueAxis = new sap.viz.ui5.controls.common.feeds.FeedItem({
                  'uid': "valueAxis",
                  'type': "Measure",
                  'values': ["Export", "Import"]
            });
            bucketCategoryAxis = new sap.viz.ui5.controls.common.feeds.FeedItem({
                  'uid': "categoryAxis",
                  'type': "Dimension",
                  'values': ["Bucket ID"]
            });
            
            dbValueAxis = new sap.viz.ui5.controls.common.feeds.FeedItem({
                  'uid': "valueAxis",
                  'type': "Measure",
                  'values': ["Export", "Import"]
            });
            dbCategoryAxis = new sap.viz.ui5.controls.common.feeds.FeedItem({
                  'uid': "categoryAxis",
                  'type': "Dimension",
                  'values': ["Bucket ID"]
            });
        },
        
        valueSelected : function(oEvent)
        {
            // If more than 1 element is selected, user selected all elements show the aggregated
            if(oEvent.getParameter("data").length > 1)
            {
                this._oDialog.setTitle("Bucket Aggregated");
                this._createCpuTimeCharts(0, "Aggregated", oAggregatedModel);
                //don't show the tables when aggregated is selected
                this._oDialog.getContent()[1].setVisible(false);
            }
            else
            {
                this._oDialog.getContent()[1].setVisible(true);
                var selectedIdx = oEvent.getParameter("data")[0].data._context_row_number;
                var selectedId = oEvent.getParameter("data")[0].data["Bucket ID"];
                this._oDialog.setTitle("Bucket " + selectedId);
                this._createCpuTimeCharts(selectedIdx, selectedId, oModel);
                this._createCloneTablesTable(selectedIdx, selectedId);
            }
            this._oDialog.open();
        },
        
        closeDialog : function()
        {
            this._oDialog.close();
        },
        
        _createCpuTimeCharts : function(idx, id, model)
        {
            if(popupCPUTimesView == null) {
                var timesModel = this._getTimesModel(idx, model);
                var timesDataset = new sap.viz.ui5.data.FlattenedDataset({
                    dimensions : [ {
                        axis : 1,
                        value : "{type}"
                    } ],
                    measures : [ {
                        name : 'Realtime',
                        value : '{realtime}'
                    }, {
                        name : 'Usertime',
                        value : '{usrtime}'
                    }, {
                        name : 'Systemtime',
                        value : '{systime}'
                    }],
                    data : {
                        path : "/times"
                    }
                });
                popupCPUTimesView = this._oDialog.getContent()[0];
                popupCPUTimesView.setModel(timesModel);
                popupCPUTimesView.setVizProperties({
                    title: {
                        visible: true,
                        text: "Usage Time"
                    },
                    valueAxis : {
                        title : {
                            visible : true,
                            text : "Time (in sec)"
                        }
                    },
                    categoryAxis : {
                        title : {
                            visible : true,
                            text : "Export/Import"
                        }
                    }
                });
            }
            //if there is already a chart, just change the model and the title
            else {
                popupCPUTimesView.setModel(this._getTimesModel(idx, model));
                popupCPUTimesView.setVizProperties({
                    title: {
                        visible: true,
                        text: "Usage Time"
                    },
                });
            }
        },
        
        _createCloneTablesTable : function(idx, id)
        {
            var tableModel = this._getTableModel(idx);
            popupTablesView = this._oDialog.getContent()[1];
            popupTablesView.setModel(tableModel);
        },
        
        _getTimesModel : function(idx, model)
        {
            var expTime1 = this._genCPUTime(model.getProperty("/buckets/" + (idx) + "/exp/cputimes/db/type") + " Export",
                    model.getProperty("/buckets/" + (idx) + "/exp/cputimes/db/realtime"),
                    model.getProperty("/buckets/" + (idx) + "/exp/cputimes/db/usrtime"),
                    model.getProperty("/buckets/" + (idx) + "/exp/cputimes/db/systime"));
    
            var impTime1 = this._genCPUTime(model.getProperty("/buckets/" + (idx) + "/imp/cputimes/db/type") + " Import",
                    model.getProperty("/buckets/" + (idx) + "/imp/cputimes/db/realtime"),
                    model.getProperty("/buckets/" + (idx) + "/imp/cputimes/db/usrtime"),
                    model.getProperty("/buckets/" + (idx) + "/imp/cputimes/db/systime"));
    
            var jsonModel = new sap.ui.model.json.JSONModel();
            jsonModel.setData({ "times" : [ expTime1, impTime1 ] });
            return jsonModel;
        },
        
        _getTableModel : function(idx)
        {
            var expTables = oModel.getProperty("/buckets/" + idx + "/exp/tables");
            var impTables = oModel.getProperty("/buckets/" + idx + "/imp/tables");
            
            var allTables = [];
            
            if(expTables !== null)
            {
                expTables.forEach(function(item) {
                    allTables.push(item);
                });
            }
            
            if(impTables !== null)
            {
                impTables.forEach(function(item) {
                    allTables.push(item);
                });
            }
            
            var tablesModel = new sap.ui.model.json.JSONModel();
            tablesModel.setData({ "tables" : allTables });
            return tablesModel;
        },
        
        switchChart : function(oEvent)
        {
            var view = this.getView();
            var content = view.byId("bucketChartContainer").getSelectedContent();
            
            if(content.getProperty("title") == "Bucket Viewer") {
                view.byId("fileSelector").setVisible(true);
                view.byId("dataSelector").setVisible(true);
            }
            else {
                view.byId("fileSelector").setVisible(false);
                view.byId("dataSelector").setVisible(false);
            }
        },
        
        _genCPUTime : function(type, realtime, usrtime, systime)
        {
            return {
                "type"        : type,
                "realtime"    : realtime,
                "negrealtime" : (-1) * realtime,
                "usrtime"     : usrtime,
                "systime"     : systime
            };
        }
    });
});
