var CLONEDURATIONS_TAG = "CloneDurations";
var CLONEDURATION_TAG = "CloneDuration";

var DMO_DUR_DATA;
var DMO_DUR_MAXVAL;

sap.ui.controller("controllers.charts.dmoDurViewer", {
	onInit: function(evt) {
		var that = this;
		var view = this.getView();
		
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.DMO_DUR_VIEWER);

		var oModel = new sap.ui.model.json.JSONModel("controllers/charts/dmoFiles.json");
        view.setModel(oModel, "allFiles");
        
        var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
        
        var finalCallback = function(that) {
            that.fnLoadChart();
        };
        
        UIGetFilesFromJsonAdd2Selector("controllers/charts/dmoFiles.json", 
                                       "DurationsViewer", view.byId("fileSelector"),
                                       finalCallback, this);

        /* register popup */
        if(!this._oDialog) {
			this._oDialog = sap.ui.xmlfragment("views.charts.dmoDurViewer", this);
			view.addDependent(this._oDialog);
		}
	},
	
	onExit: function() {
		this.page.destroy();
		delete this.page;
	},
	
	/* ***************************************************************** */
	/*	CHANGE CONTENT
	/* ***************************************************************** */
	fnContentChange : function(oControlEvent) {
		var view = this.getView();
		var content = view.byId("durViewerChartContainer").getSelectedContent();
		
		if(content.getProperty("title") == "Duration Viewer") {
			view.byId("fileSelector").setVisible(true);
		}
		else {
			view.byId("fileSelector").setVisible(false);
		}
	},
	
	/* ***************************************************************** */
	/*	LOAD CHART
	/* ***************************************************************** */
	fnLoadChart : function(oControlEvent) {
		var view = this.getView();
		
		/* check selector */
		var oSelect = view.byId("fileSelector");
		var item = oSelect.getSelectedItem();
		if(item == null) {
			item = oSelect.getFirstItem();
		}
		if(item == null) {
			return;
		}
		
		/* set busy indicator */
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
		
		this.DMO_DUR_DATA = {};
		this.DMO_DUR_DATA.data = [];
		this.DMO_DUR_MAXVAL = -1;
		
		/* read callback */
		this._getXmlContent = function(data, that) {
			
			if(data == null) {
				return;
			}
			
			var xmlNode = $(CLONEDURATIONS_TAG, data);
			
			var maxVal = UIGetAttribute(xmlNode, "totaltime", -1)/1;
			if(maxVal < 0) {
			    maxVal = UIGetAttribute(xmlNode, "time", 0)/1;
			}
			that.DMO_DUR_MAXVAL = maxVal;
			
			var factor = maxVal/100;
			
			var xmlDurs = xmlNode.find(CLONEDURATION_TAG);
			var stats = [];
			
			/* parse xml */
			for(var x = 0; x < xmlDurs.length ; x++) {
				var xmlDur = xmlDurs[x];
				
				var table = UIGetAttribute(xmlDur, "table", "");
				var start = that._getString2Time(UIGetAttribute(xmlDur, "starttime", 0));
				var end   = that._getString2Time(UIGetAttribute(xmlDur, "endtime", 0));

                var lenperc = UIGetAttribute(xmlDur, "lenperc", 0)/1;

				var expdur  = UIGetAttribute(xmlDur, "expduration", 0)/1;
				var impdur  = UIGetAttribute(xmlDur, "impduration", 0)/1;
				var exprow  = UIGetAttribute(xmlDur, "exprowcount", 0)/1;
				var improw  = UIGetAttribute(xmlDur, "improwcount", 0)/1;
				
				var dur = expdur > impdur ? expdur : impdur;
				var row = exprow > improw ? exprow : improw;
				
				var oStart  = new Date(start);
				var oEnd    = new Date(end);
				var runtime = (oEnd - oStart)/1000;
				
				if(runtime < 20 || lenperc < 1) {
				    continue;
				}
				
				var nsplits = UIGetAttribute(xmlDur, "nrsplits", 0)/1;
				if(nsplits > 0 && dur <= runtime) {
				    nsplits = 0;
			    }
				
				var dummyEnd = {};
				dummyEnd.dummyId    = 0;
				dummyEnd.tableName  = table;
				dummyEnd.xaxis 		= (100 - UIGetAttribute(xmlDur, "endperc", 0)/1) * factor;
				
				var entry = {};
				entry.dummyId     = 1;
				entry.tableName   = table;
				entry.xaxis  	  = lenperc * factor;
				entry.tableSize   = UIGetAttribute(xmlDur, "size", 0)/1024.;
				entry.starttime   = start;
				entry.endtime     = end;
				entry.runtime     = runtime;
				entry.duration    = dur;
				entry.rowcount    = row;
				entry.nsplits     = nsplits;
				entry.kbpersecond = UIGetAttribute(xmlDur, "kbpersecond", 0)/1;
				
				var dummyStart = {};
				dummyStart.dummyId    = 2;
				dummyStart.tableName  = table;
				dummyStart.xaxis 	  = UIGetAttribute(xmlDur, "startperc", 0)/1 * factor;
				
				var stat = {};
				stat.entry = entry;
				stat.dummyEnd = dummyEnd;
				stat.dummyStart = dummyStart;
				
				stats.push(stat);
			}
			
			/* sort by real runtime */
			stats.sort(function(stat1, stat2) {
				return stat2.entry.runtime - stat1.entry.runtime;
			});
			
			/* put statistics into model */
			for(var x = 0 ; x < stats.length ; x++) {
				that.DMO_DUR_DATA.data.push(stats[x].dummyEnd);
				that.DMO_DUR_DATA.data.push(stats[x].entry);
				that.DMO_DUR_DATA.data.push(stats[x].dummyStart);
			}

			that.fnUpdateChart(null);
		};
		
		$.ajax({
			url: item.getKey(),
			type: "GET",
			dataType: "xml",
			cache: false,
			context: this,

			error: function() {
				this._getXmlContent(null, this);
			},
			
			success: function(data) {
				this._getXmlContent(data, this);
			}
		});
	},
	
	/* ***************************************************************** */
	/*	UPDATE CHART
	/* ***************************************************************** */
	fnUpdateChart : function(oControlEvent) {
		this.view = this.getView();
		
		var oVizFrame = this.view.byId("idoVizFrame");
		if(!oVizFrame.isBusy()) {
			oVizFrame.setBusy(true);
		}
		
		/* render chart asynchronously */
		var renderCallback = function(that) {
			
			var amModel = new sap.ui.model.json.JSONModel();
			amModel.setData(that.DMO_DUR_DATA);

			var oVizFrame = that.view.byId("idoVizFrame");
			oVizFrame.setModel(amModel);
			
			/* Check if table is dummy entry */
			var cbIsDummy = function(oContext) {
				var array = oVizFrame.getModel().getData().data;
				
				var bindingContext = oContext._context_row_number;
				var bindingData = array[bindingContext];
				
				if(!bindingData)
					return false;

				if(bindingData['dummyId'] !=  1)
					return true;

				return false;
			};
			
			/* Check if table has been split */
			var cbIsSplit = function(oContext) {
				var array = oVizFrame.getModel().getData().data;
				
				var bindingContext = oContext._context_row_number;
				var bindingData = array[bindingContext];
				
				if(!bindingData)
					return false;

				if(bindingData['dummyId'] !=  1)
					return false;
				
				if(bindingData['nsplits'] > 1)
					return true;

				return false;
			};
			
	    	oVizFrame.setVizProperties({
				title: {
					visible: true,
					text: "Table Durations"
				},
				plotArea: {
					dataPointStyle: {
						rules: 
						[{
							callback: cbIsDummy,
							properties: {
								color: '#f2f2f2'
							},
							displayName: ""
						 }, {
							callback: cbIsSplit,
							properties: {
							 	color: '#b6d957'
						 	},
						 	displayName: "Table has been split"
						 }],
						others:
						{
							properties: {
								color: '#5cbae6'
							},
							displayName: "Table has not been split"
						}
					}
				},
				xAxis: {
					scale: {
						fixedRange: true,
						minValue: 0,
						maxValue: that.DMO_DUR_MAXVAL
					}
				},
				interaction : {
					selectability : {
						mode: "single"
					}
				},
				tooltip: {
					visible: false,
				}
			});
		};
		
		UICallAsyncFunction(renderCallback, this);
	},
	
	/* ***************************************************************** */
	/*	RENDERING COMPLETE
	/* ***************************************************************** */
	fnRenderComplete : function(oControlEvent) {
		var view = this.getView();
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(false);
	},
	
	/* ***************************************************************** */
	/*	SELECT DATA
	/* ***************************************************************** */
	fnSelectData : function(oControlEvent) {
		var view = this.getView();
		
		var oVizFrame = view.byId("idoVizFrame");
		var array = oVizFrame.getModel().getData().data;
		var row = oControlEvent.getParameter("data")[0].data._context_row_number;
		var table = array[row];
		
		if(table.dummyId != 1) {
			return; /* skip dummy entries */
		}
		
		var modelString = '{"tableDetails" : [' +
			'{ "name" : "Table Name:", "value" : "' + table['tableName'] + '"}, ' +
			'{ "name" : "Table Size:", "value" : "' + parseFloat(table['tableSize']).toFixed(2) + ' MB"}, ' +
			'{ "name" : "Start Time:", "value" : "' + table['starttime']   + '"}, ' +
			'{ "name" : "End Time:", "value" : "' + table['endtime']     + '"}, ' +
			'{ "name" : "Real Duration:", "value" : "' + table['runtime']     + ' sec"}, ' +
			'{ "name" : "Parallel Duration:", "value" : "' + table['duration']    + ' sec"}, ' +
			'{ "name" : "Numer of Splits:", "value" : "' + table['nsplits']     + '"}, ' +
			'{ "name" : "Rowcount:", "value" : "' + table['rowcount']    + '"}, ' +
			'{ "name" : "Rate:", "value" : "' + table['kbpersecond'] + ' KB/sec"}]}';

		var model = new sap.ui.model.json.JSONModel();
		model.setJSON(modelString);
		
		var oDetails = this._oDialog.getContent()[0];
		oDetails.setModel(model);
		
		this._oDialog.open();
	},
	
	/* ***************************************************************** */
	/*	HELPER FUNCTIONS
	/* ***************************************************************** */
	_getString2Time : function(string) {
		if(string.length < 14) {
			return string;
		}

		var year = string.slice(0,4);
		var month = string.slice(4,6);
		var day = string.slice(6,8);
		
		var hour = string.slice(8,10);
		var min = string.slice(10,12);
		var sec = string.slice(12,14);
		
		return year + "-" + month + "-" + day + " " + hour + ":" + min + ":" + sec;
	}
});
