var DMO_TABSEQ_DATA;

sap.ui.controller("controllers.charts.dmoTableSequence", {
	onInit: function() {
		var that = this;
		var view = this.getView();
		
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.DMO_TABLE_SEQUENCE);
		
		/* set label format */
		var FIORI_LABEL_FORMAT_2 = "__UI5__FloatMaxFraction2";
		var chartFormatter = sap.viz.ui5.format.ChartFormatter.getInstance();
		chartFormatter.registerCustomFormatter(FIORI_LABEL_FORMAT_2, function(value) {
            var fixedFloat = sap.ui.core.format.NumberFormat.getFloatInstance({style: 'Standard', maxFractionDigits: 2});
            return fixedFloat.format(value);
        });
		sap.viz.api.env.Format.numericFormatter(chartFormatter);
		
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
		
		/* register popover */
		this.oPopOver = view.byId("idPopOver");
		this.oPopOver.connect(oVizFrame.getVizUid());
		this.oPopOver.setFormatString(FIORI_LABEL_FORMAT_2);
		
		var oModel = new sap.ui.model.json.JSONModel("controllers/charts/dmoFiles.json");
        view.setModel(oModel, "allFiles");
        
        var finalCallback = function(that) {
        	that.fnLoadChart();
        };
        
        UIGetFilesFromJsonAdd2Selector("controllers/charts/dmoFiles.json", 
        							   "TableSequence", view.byId("fileSelector"),
        							   finalCallback, this);
	},
	
	onExit: function() {
		this.oPopOver.destroy();
		delete this.oPopOver;
		
		this.page.destroy();
		delete this.page;
	},
	
	/* ***************************************************************** */
	/*	CHANGE CONTENT
	/* ***************************************************************** */
	fnContentChange : function(oControlEvent) {
		var view = this.getView();
		var content = view.byId("tabSeqChartContainer").getSelectedContent();
		
		if(content.getProperty("title") == "Table Sequence") {
			view.byId("fileSelector").setVisible(true);
			view.byId("dataSelector").setVisible(true);
		}
		else {
			view.byId("fileSelector").setVisible(false);
			view.byId("dataSelector").setVisible(false);
		}
	},
	
	/* ***************************************************************** */
	/*	LOAD CHART
	/* ***************************************************************** */
	fnLoadChart : function(oControlEvent) {
		var view = this.getView();
		
		/* check selector */
		var oSelect = view.byId("fileSelector");
		var item = oSelect.getSelectedItem();
		if(item == null) {
			item = oSelect.getFirstItem();
		}
		if(item == null) {
			return;
		}
		
		/* set busy indicator */
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
		
		this.DMO_TABSEQ_DATA = {};
		this.DMO_TABSEQ_DATA.data = [];

		this.id = -1;
		
		/* read callback */
		var readLineByLine = function(data, that) {
			if(data != null) {
				var tempRec = {};
				
				tempRec.id = that.id;
				tempRec.steps = data[0];
				tempRec.estRuntime = data[1];
				tempRec.realSize = data[2] / 1024;
				
				that.DMO_TABSEQ_DATA.data.push(tempRec);
				that.id = that.id + 1;
				
				return;
			}
			
			that.fnUpdateChart(null);
		};
		
		var dataSourceUrl = item.getKey();
		UIReadCSVFile(dataSourceUrl, readLineByLine, this);
	},
	
	/* ***************************************************************** */
	/*	UPDATE CHART
	/* ***************************************************************** */
	fnUpdateChart : function(oControlEvent) {
		this.view = this.getView();

		/* check data selector */
		var oOption = this.view.byId("dataSelector");
		var option = oOption.getSelectedItem();
		if(option == null) {
			option = oOption.getFirstItem();
		}
		if(option == null) {
			return;
		}
		
		this.mode = 0;
		this.title = "Final Table Sequence";
		if(option.getKey() == 1) {
			this.mode = 1;
			this.title = "Sorted Table Sequence";
		}
		
		var oVizFrame = this.view.byId("idoVizFrame");
		if(!oVizFrame.isBusy()) {
			oVizFrame.setBusy(true);
		}
		
		var renderCallback = function(that) {
			
			if(that.mode == 1) {
				/* sort data in descending order */
				that.DMO_TABSEQ_DATA.data.sort(function(a, b) {
					return b.estRuntime - a.estRuntime;
				});
			} else {
				/* sort data in originally order */
				that.DMO_TABSEQ_DATA.data.sort(function(a, b) {
					return a.id - b.id;
				});
			}
			
			var amModel = new sap.ui.model.json.JSONModel();
			amModel.setData(that.DMO_TABSEQ_DATA);
			
			var oVizFrame = that.view.byId("idoVizFrame");
			oVizFrame.setModel(amModel);
			oVizFrame.setVizProperties({
				title: {
					visible: true,
					text: that.title
				}
			});
			
		};
		
		UICallAsyncFunction(renderCallback, this);
	},
	
	/* ***************************************************************** */
	/*	RENDERING COMPLETE
	/* ***************************************************************** */
	fnRenderComplete : function(oControlEvent) {
		var view = this.getView();
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(false);
	}
});
