var TABLESPLITDISTRIBUTION_TAG = "TableSplitDistribution";
var PROCESSSLOTS_TAG = "ProcessSlots";
var PROCESSSLOT_TAG = "ProcessSlot";
var PROCESSCHUNK_TAG = "ProcessChunk";

sap.ui.controller("controllers.charts.dmoTableSplits", {
	onInit: function() {
		var that = this;
		var view = this.getView();
		
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.DMO_TABLE_SPLITS);

		that.MAXRUNTIME = 0;
		that.MINTABRUNTIME = 5;
		
		var oModel = new sap.ui.model.json.JSONModel("controllers/charts/dmoFiles.json");
        view.setModel(oModel, "allFiles");
        
        var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
        
        var finalCallback = function(that) {
            that.fnLoadChart();
        };
        
        UIGetFilesFromJsonAdd2Selector("controllers/charts/dmoFiles.json", 
                                       "TableSplits", view.byId("fileSelector"),
                                       finalCallback, this);
		
		// create dialog via fragment factory
		if(!this._oDialog) {
			this._oDialog = sap.ui.xmlfragment("views.charts.dmoTableSplits", this);
			// connect dialog to view (models, lifecycle)
			this.getView().addDependent(this._oDialog);
		}
	},
	
	onExit: function() {
		this.page.destroy();
		delete this.page;
	},
	
	/* ***************************************************************** */
	/*	CHANGE CONTENT
	/* ***************************************************************** */
	fnContentChange : function(oControlEvent) {
		var view = this.getView();
		var content = view.byId("tabSplitChartContainer").getSelectedContent();
		
		if(content.getProperty("title") == "Table Splits") {
			view.byId("fileSelector").setVisible(true);
			view.byId("algoSelector").setVisible(true);
		}
		else {
			view.byId("fileSelector").setVisible(false);
			view.byId("algoSelector").setVisible(false);
		}
	},
	
	/* ***************************************************************** */
	/*	SHOW CHUNK DETAILS
	/* ***************************************************************** */
	fnShowChunkDetails : function(oEvent) {
		var view = this.getView();
		
		if(oEvent.getParameter("data").length > 1) {
			return; /* only show single chunk details */
		}
		
		var oVizFrame = view.byId("idoVizFrame");
		var array = oVizFrame.getModel().getData().data;
		var row = oEvent.getParameter("data")[0].data._context_row_number;
		var chunk = array[row];
		
		var nsplits = parseInt(1/chunk['segSize']);
		var tableSize = parseFloat(chunk['tableSize']).toFixed(2);
		var tableRuntime = parseFloat(chunk['tableRuntime']).toFixed(2);
		var chunkRuntime = parseFloat(chunk['chunkRuntime']).toFixed(2);
		
		var model = {};
		model.chunkDetails = [];
		
		model.chunkDetails.push({"name" : "Table Name:", "value" : chunk['tableName']});
		if(chunk.flag != 1) /* merged tables */ {
			model.chunkDetails.push({"name" : "Table Size:", "value" : tableSize + ' MB'});
			model.chunkDetails.push({"name" : "Table Est. Runtime:", "value" : tableRuntime + ' sec'});
		}
		model.chunkDetails.push({"name" : "Chunk Est. Runtime:", "value" : chunkRuntime + ' sec'});
		if(nsplits > 0) {
			model.chunkDetails.push({"name" : "Number of Splits:", "value" : nsplits});
		}
		
		var cModel = new sap.ui.model.json.JSONModel();
		cModel.setData(model);
		
		var oChunkDetails = this._oDialog.getContent()[0];
		oChunkDetails.setModel(cModel);
		
		this._oDialog.open();
	},
	
	/* ***************************************************************** */
	/*	LOAD CHART
	/* ***************************************************************** */
	fnLoadChart : function(oControlEvent) {
		var view = this.getView();
		
		/* check selector */
		var oSelect = view.byId("fileSelector");
		var item = oSelect.getSelectedItem();
		if(item == null) {
			item = oSelect.getFirstItem();
		}
		if(item == null) {
			return;
		}
		
		/* set busy indicator */
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
		
		this.DMO_TABSPLIT_ON_DATA = {};
		this.DMO_TABSPLIT_OFF_DATA = {};
		
		this.DMO_TABSPLIT_ON_DATA.data = [];
		this.DMO_TABSPLIT_OFF_DATA.data = [];
		
		this.MAXRUNTIME = 0;
        
        this.DUR_FILE_USED = false;
		
		/* read callback */
		this._getXmlContent = function(data, that) {
			
			if(data == null) {
				return;
			}
			
			var xmlNode = $(TABLESPLITDISTRIBUTION_TAG, data);
			var xmlIters = xmlNode.find(PROCESSSLOTS_TAG);
            
            that.DUR_FILE_USED = UIGetBoolean(UIGetAttribute(xmlNode, "durfileused", false));

			if(xmlIters[0]) { 
				that._parseSlots(that.DMO_TABSPLIT_OFF_DATA.data, xmlIters[0]);
			}
			if(xmlIters[1]) { 
				that._parseSlots(that.DMO_TABSPLIT_ON_DATA.data, xmlIters[1]);
			}

			that.fnUpdateChart(null);
		};
		
		$.ajax({
			url: item.getKey(),
			type: "GET",
			dataType: "xml",
			cache: false,
			context: this,

			error: function() {
				this._getXmlContent(null, this);
			},
			
			success: function(data) {
				this._getXmlContent(data, this);
			}
		});
	},
	
	/* ***************************************************************** */
	
	_parseSlots : function(data, xmlIter) {
		var main = this;
		var xmlSlots = $(xmlIter).find(PROCESSSLOT_TAG);
		
		/* Parse XML data */
		for(var sId = 0 ; sId < xmlSlots.length ; sId++) {
			var xmlSlot = xmlSlots[sId];
			var slotRuntime = UIGetAttribute(xmlSlot, "slotEstRuntime", 0)/1;

			var xmlChunks = $(xmlSlot).find(PROCESSCHUNK_TAG);
			var cId = 0;
			for(var x = xmlChunks.length - 1; x >= 0 ; x--) {
				var xmlChunk = xmlChunks[x];
				var chunk = {};
				var prev = (data.length - 1 > -1) ? data[data.length - 1] : null;
				
				chunk.slotId = sId;
				chunk.chunkId = cId;
				chunk.slotRuntime = slotRuntime;
				chunk.tableName = UIGetAttribute(xmlChunk, "tableName", "");
				chunk.tableSize = UIGetAttribute(xmlChunk, "tableSize", 0)/1024;
				chunk.tableRuntime = UIGetAttribute(xmlChunk, "tableEstRuntime", 0)/1;
				chunk.chunkRuntime = UIGetAttribute(xmlChunk, "chunkEstRuntime", 0)/1;
				chunk.segSize = UIGetAttribute(xmlChunk, "segSize", 0);
				chunk.ntables = 1;
				chunk.flag = 0;
				
				if(chunk.tableRuntime <= main.MINTABRUNTIME && chunk.segSize == 0) {
					chunk.flag = 1; /* merge very small tables */
				}
				
				if(chunk.flag == 0 || !prev || prev.flag == 0 || prev.slotId != chunk.slotId) {
					data.push(chunk);
					cId++;
					continue;
				}
				
				/* merge very small tables */
				prev.tableName += "; " + chunk.tableName;
				prev.tableRuntime += chunk.tableRuntime;
				prev.chunkRuntime += chunk.chunkRuntime;
				prev.ntables += 1;
			}
			
			if(slotRuntime > main.MAXRUNTIME) {
				main.MAXRUNTIME = slotRuntime;
			}
		}
	},

	/* ***************************************************************** */
	/*	UPDATE CHART
	/* ***************************************************************** */
	fnUpdateChart : function(oControlEvent) {
		this.view = this.getView();

		/* check data selector */
		var oOption = this.view.byId("algoSelector");
		var option = oOption.getSelectedItem();
		if(option == null) {
			option = oOption.getFirstItem();
		}
		if(option == null) {
			return;
		}
		
		var oVizFrame = this.view.byId("idoVizFrame");
		if(!oVizFrame.isBusy()) {
			oVizFrame.setBusy(true);
		}
		
		this.key = option.getKey();
		
		/* render chart asynchronously */
		var renderCallback = function(that) {
			
			var amModel = new sap.ui.model.json.JSONModel();
			
			if(that.key == 0) {
				amModel.setData(that.DMO_TABSPLIT_ON_DATA);
			} else {
				amModel.setData(that.DMO_TABSPLIT_OFF_DATA);
			}
			
			var oVizFrame = that.view.byId("idoVizFrame");
			oVizFrame.setModel(amModel);
			
			/* Check if table has been splitted */
			var cbIsSplitted = function(oContext) {
				var array = oVizFrame.getModel().getData().data;
				
				var bindingContext = oContext._context_row_number;
				var bindingData = array[bindingContext];
				
				if(!bindingData)
					return false;

				if(bindingData['segSize'] > 0)
					return true;

				return false;
			};
			
			/* Check if table has been merged */
			var cbIsMerged = function(oContext) {
				var array = oVizFrame.getModel().getData().data;
				
				var bindingContext = oContext._context_row_number;
				var bindingData = array[bindingContext];
				
				if(!bindingData)
					return false;

				if(bindingData['flag'] > 0 && bindingData['ntables'] > 1)
					return true;

				return false;
			};
            
            var frameTitle = "Distribution of Tables to Process Slots";
            if(that.DUR_FILE_USED === true)
                frameTitle += " (Durations file was used)";
			
			/* chart properties */
			oVizFrame.setVizProperties({
				title: {
					visible: true,
					text: frameTitle
				},
				valueAxis: {
					title: {
						visible: true,
						text: "Estimated Runtime (in sec)"
					}
				},
				plotArea: {
					dataPointStyle: {
						rules: 
						[{
							callback: cbIsMerged,
							properties: {
								color: '#d2edf9'
							},
							displayName: "Small Tables"
						 }, {
							 callback: cbIsSplitted,
							 properties: {
							 	color: '#b6d957'
							},
							displayName: "Table has been split"
						}],
						others:
						{
							properties: {
								color: '#5cbae6'
							},
							displayName: "Table has not been split"
						}
					}
				},
				xAxis: {
					scale: {
						fixedRange: true,
						minValue: 0,
						maxValue: that.MAXRUNTIME
					}
				},
				yAxis: {
					scale: {
						fixedRange: true,
						minValue: 0
					}
				},
				interaction : {
					selectability : {
						mode: "single"
					}
				},
				tooltip: {
					visible: false,
				}
			});
		};
		
		UICallAsyncFunction(renderCallback, this);
	},
	
	/* ***************************************************************** */
	/*	RENDERING COMPLETE
	/* ***************************************************************** */
	fnRenderComplete : function(oControlEvent) {
		var view = this.getView();
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(false);
	}
});
