var DMO_TAIL_DATA;
var DMO_TAIL_DURFILE_USED;

sap.ui.controller("controllers.charts.dmoTailViewer", {

	onInit: function() {
		var that = this;
		var view = this.getView();
		
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.DMO_TAIL_VIEWER);
		
		var oModel = new sap.ui.model.json.JSONModel("controllers/charts/dmoFiles.json");
        view.setModel(oModel, "allFiles");
        
        var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(true);

        var finalCallback = function(that) {
            that.fnLoadChart();
        };
        
        UIGetFilesFromJsonAdd2Selector("controllers/charts/dmoFiles.json", 
                                       "TailViewer", view.byId("fileSelector"),
                                       finalCallback, this);
	},
	
	onExit: function() {
		this.page.destroy();
		delete this.page;
	},
	
	/* ***************************************************************** */
	/*	CHANGE CONTENT
	/* ***************************************************************** */
	fnContentChange : function(oControlEvent) {
		var view = this.getView();
		var content = view.byId("tailViewerChartContainer").getSelectedContent();
		
		if(content.getProperty("title") == "Tail Viewer") {
			view.byId("fileSelector").setVisible(true);
		}
		else {
			view.byId("fileSelector").setVisible(false);
		}
	},
	
	/* ***************************************************************** */
	/*	LOAD CHART
	/* ***************************************************************** */
	fnLoadChart : function(oControlEvent) {
		var view = this.getView();
		
		/* check selector */
		var oSelect = view.byId("fileSelector");
		var item = oSelect.getSelectedItem();
		if(item == null) {
			item = oSelect.getFirstItem();
		}
		if(item == null) {
			return;
		}
		
		/* set busy indicator */
		var oVizFrame = view.byId("idoVizFrame");
		if(!oVizFrame.isBusy()) {
			oVizFrame.setBusy(true);
		}
		
		this.DMO_TAIL_DATA = {};
		this.DMO_TAIL_DATA.data = [];
		
		this.DMO_TAIL_DURFILE_USED = 0;
		
		/* read callback */
		var readLineByLine = function(data, that) {
			if(data != null) {
				var tempRec = {};
				var seconds = data[0];
				
				tempRec.time =  that.fnSeconds2Time(seconds);
				tempRec.numProcs = data[1];
				tempRec.completion = 0;
				
				if(data[2]) {
					tempRec.completion = data[2];
				}
				
				that.DMO_TAIL_DATA.data.push(tempRec);
				return;
			}
			
			that.fnUpdateChart(null);
		};
		
		/* read comments callback */
		var commentsCallback = function(comment, that) {
		    if(comment.startsWith("# Durations file was used")) {
		    	that.DMO_TAIL_DURFILE_USED = 1;
		    }
		};
		
		var dataSourceUrl = item.getKey();
		UIReadCSVFile1(dataSourceUrl, readLineByLine, commentsCallback, this);
	},
	
	/* ***************************************************************** */
	/*	UPDATE CHART
	/* ***************************************************************** */
	fnUpdateChart : function(oControlEvent) {
		this.view = this.getView();
		
		var oVizFrame = this.view.byId("idoVizFrame");
		oVizFrame.setBusy(true);
		
		var renderCallback = function(that) {

			var amModel = new sap.ui.model.json.JSONModel();
			amModel.setData(that.DMO_TAIL_DATA);
			
			var chartTitle = "Number of Parallel R3load Processes and Completion";
			if(that.DMO_TAIL_DURFILE_USED == 1) {
			    chartTitle += " (Durations file was used)";
			}
			
			var oVizFrame = that.view.byId("idoVizFrame");
			oVizFrame.setModel(amModel);
			oVizFrame.setVizProperties({
				legend: {
					title: {
						visible: false
					}
				},
				title: {
					visible: true,
					text: chartTitle
				},
				plotArea: {
					marker: {
						visible: false
					}
				},
				yAxis2: {
					scale: {
						fixedRange: true,
						minValue: 0,
						maxValue: 100
					}
				}
			});
		};
		
		UICallAsyncFunction(renderCallback, this);
	},
	
	/* ***************************************************************** */
	/*	RENDERING COMPLETE
	/* ***************************************************************** */
	fnRenderComplete : function(oControlEvent) {
		var view = this.getView();
		var oVizFrame = view.byId("idoVizFrame");
		oVizFrame.setBusy(false);
	},
	
	/* ***************************************************************** */
	/*	HELPER FUNCTIONS
	/* ***************************************************************** */
	fnSeconds2Time : function(seconds) {
		var d = Number(seconds);
		var h = Math.floor(d / 3600);
		var m = Math.floor(d % 3600 / 60);
		var s = Math.floor(d % 3600 % 60);
		return ((h > 0 ? h + ":" + (m < 10 ? "0" : "") : "") + m + ":" + (s < 10 ? "0" : "") + s);
	}
});
