/* global sap jQuery util */
/* eslint-disable strict, no-underscore-dangle */

sap.ui.controller("controllers.controls", {

	onInit: function() {

		// register for onBeforeShow events for "pages"
		this.getView().addEventDelegate({
			onBeforeShow: jQuery.proxy(function(evt) {
				this._onBeforeShow(evt);
			}, this)
		});
	},

	_onBeforeShow: function(evt) {
		if (evt && evt.data) {
			this.getView().setBindingContext(evt.data.context);
		}
	},
	
	_getControlFromItem: function(item) {
		var model = sap.ui.getCore().getModel();
		var path = item.getSelectedContextPaths()[0];
		var control = model.getProperty(path);
		if(control == undefined || control.length == 0) {
			return null;
		}
		return sap.ui.getCore().byId(control.id);
	},

	itemPress: function(evt) {
		this._navigate(evt.getSource());
	},

	listSelect: function(evt) {
		this._navigate(evt.getParameter("listItem"));
		var lastControl = this.lastControl;
        this.hook = evt.getSource(); //remember the handle to the list for a later removal of the selection
        var newControl = this._getControlFromItem(this.hook);
        if (lastControl && lastControl !== newControl) {
                lastControl.destroy();
        }
        this.lastControl = newControl;
	},

	_navigate: function(item) {

		var model = sap.ui.getCore().getModel();
		var path = item.getBindingContext().getPath();
		var control = model.getProperty(path);

		// check theme support
		if (control.noMVI && util.ThemeDetection.isMVI()) {
			this._showThemeNotSupportedMsg("Mobile Visual Identity");
		} else if (control.noBC && util.ThemeDetection.isBC()) {
			this._showThemeNotSupportedMsg("Blue Crystal");
		} else {
			sap.ui.getCore().getEventBus().publish("nav", "to", {
				id: control.id,
				doc: (control.doc ? control.doc : null),
				data: (control.data ? control.data : null)
			});
		}
	},

	_showThemeNotSupportedMsg: function(themeName) {
		jQuery.sap.require("sap.m.MessageBox");
		sap.ui.getCore().getEventBus().publish("nav", "virtual");
		sap.m.MessageBox.alert("This control does not support the '" + themeName + "' theme", function(oAction) {
			if (oAction) {
				sap.ui.getCore().getEventBus().publish("nav", "back");
			}
		});
	},

	navBack: function() {
		if (this.hook) {								// when hook was set before in listSelect()
			this.hook.removeSelections();
			this.hook = undefined;
		}
		sap.ui.getCore().getEventBus().publish("nav", "back");
	},

	formatIcon: function(img, noMVI, noBC) {
		if (noMVI && util.ThemeDetection.isMVI()) {
			return "sap-icon://alert";
		} else if (noBC && util.ThemeDetection.isBC()) {
			return "sap-icon://alert";
		} else if (img === "Control") {
			return "sap-icon://database";
		} else if (img === "Graph") {
			return "sap-icon://line-chart";
		} else if (img === "Settings") {
			return "sap-icon://settings";
		} else if (img === "Experiment") {
			return "sap-icon://lab";
		} else if (img === "Doc") {
			return "sap-icon://attachment-html";
		} else if (img === "Wrench") {
			return "sap-icon://wrench";
		} else if (img === "Role") {
			return "sap-icon://role";
		} else if (img === "Dir") {
			return "sap-icon://add-product";
		} else if (img === "Key") {
			return "sap-icon://key";
		} else if (img === "Process") {
			return "sap-icon://restart";
		} else {
			return "sap-icon://question-mark";
		}
	}
});
