/* global sap jQuery util */
/* eslint-disable strict, no-undef, no-underscore-dangle, no-unused-vars */

sap.ui.controller("controllers.docs.upgana", {

	onInit: function(evt) {
		// get the page
		var view = this.getView();
		view.setModel(new sap.ui.model.json.JSONModel({"upgana": "../doc/analysis/UPGANA.XML"}));
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.UPGANA);
	},

	handleFullScreen: function(oEvent) {
            window.open("../doc/analysis/UPGANA.XML", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");
	},
	
	handleDownload: function(oEvent) {
		var xhr = new XMLHttpRequest(); 
		xhr.open("GET", "../doc/analysis/UPGANA.XML"); 
		xhr.responseType = "blob";
		xhr.onload = function() { 
			if (xhr.status !== 200) {
				sap.m.MessageToast.show("File UPGANA.XML not found!");
				return;
			}
			if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(xhr.response, "UPGANA.XML");
			else {
				var elem = window.document.createElement('a');
				elem.href = window.URL.createObjectURL(xhr.response);
				elem.download = "UPGANA.XML";        
				document.body.appendChild(elem);
				elem.click();        
				document.body.removeChild(elem);
			}    		
		};
		xhr.send();
	},

	onBeforeRendering: function() {
		this.getView().byId("idPan2").getBinding("content").resume();
	}

});
