/* global sap jQuery util */
/* eslint-disable strict, no-undef, no-underscore-dangle, no-unused-vars */

sap.ui.controller("controllers.slp.resource", {

	onInit: function(evt) {
		// get the page
		var view = this.getView();
		this.page = view.byId("page");
		util.UiFactory.fillPageHeader(this.page, view, util.Title.SUM_REST_API);
                var urlDetails = getURLDetails();
                var oModel = new sap.ui.model.json.JSONModel();
		
                $.getJSON("slpapi.json?" + Math.random(), function (data) {
		    for (var ii = 0; ii < data.SLPApi.length; ii++)
		    {
			data.SLPApi[ii].LinkURL = data.SLPApi[ii].LinkURL.replace(/\|prot\|/g, urlDetails.protocol);
                        data.SLPApi[ii].LinkURL = data.SLPApi[ii].LinkURL.replace(/\|hostname\|/g, urlDetails.hostname);
                        data.SLPApi[ii].LinkURL = data.SLPApi[ii].LinkURL.replace(/\|toolmode\|/g, urlDetails.toolmode);
                        data.SLPApi[ii].LinkURL = data.SLPApi[ii].LinkURL.replace(/\|sid\|/g, urlDetails.sid);
		    }
                    oModel.setData(data);
                    view.setModel(oModel);
		});

		view.addEventDelegate({
			onAfterShow: jQuery.proxy(function(evt) {
				this.onAfterShow(evt);
			}, this)
		});
	},

	handleSelectChange: function(oEvent) {

	},

	handleLinkPress: function(oEvent) {
            var link = oEvent.getSource().getBindingContext().getProperty("LinkURL");
            window.open(link, "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");
	},

	handleDetailPress: function(oEvent) {

	},

	handleDelete: function(oEvent) {

	},

	/**
	 * Called after the page is shown
	 */
	onAfterShow: function(event) {

	}

});
