sap.ui.controller("controllers.sumui.setmigpar", {

    onInit: function(evt) {
        this.view = this.getView();
        this.page = this.view.byId("page");
        this.data = evt.getSource().getViewData();

        this.oKeyInput = this.view.byId("oKeyInput");
        this.oRepInput = this.view.byId("oRepInput");

        UIGetRemoteControls(this._loadRemoteControls, this);
    },

    _loadRemoteControls: function(xmlData, that) {
        var migKey = UIGetRemoteControlValue(xmlData, "MigrationKey", "");
        var repInp = UIGetRemoteControlValue(xmlData, "MigrationOptimizeCloning", 0);
        
        repInp = UIGetBoolean(repInp);
        
        that.oKeyInput.setValue(migKey);
        that.oRepInput.setSelected(repInp);
    },

    onBeforeRendering: function(evt) {
        util.UiFactory.fillPageHeader(this.page, this.view, this.data.desc);
    },

    handleSubmit: function() {
        var entries = [];
        entries.push({ remId: "MigrationKey", value: this.oKeyInput.getValue() });
        entries.push({ remId: "MigrationOptimizeCloning", value: this.oRepInput.getSelected() });
        UIPostRemoteControls("Change(s)", entries, true);
    },

    handleCancel: function() {
        this.oKeyInput.setValue("");
        this.oRepInput.setSelected(false);
        UIGetRemoteControls(this._loadRemoteControls, this);
    }
});
