/* global sap jQuery util */
/* eslint-disable strict, no-undef, no-underscore-dangle, no-unused-vars */

sap.ui.controller("controllers.sumui.setparams", {

	onInit: function(evt) {
		// get the page
		this.view = this.getView();
		this.page = this.view.byId("page");
	},
        
	onBeforeRendering: function(evt) {
		this.data = evt.getSource().getViewData();
		util.UiFactory.fillPageHeader(this.page, this.view, this.data.desc);
        this.page.setBusy(true);
	},
	
    onAfterRendering: function() {
    	var completeUrl = "../" + this.data.uri;
    	jQuery("div[id='sum_set_params']").css("width", "100%").css("height", "100%");
    	jQuery("div[id='sum_set_params']").html("<iframe id='iFrame' src='" + completeUrl + "' frameborder='0' scrolling='yes' style='overflow-y:scroll !important; overflow-x:hidden !important; overflow:hidden;height:1000px;width:100%'></iframe>");                
    	document.getElementById('iFrame').onload = $.proxy(function() {this.page.setBusy(false);}, this);
    }
});
