/* global sap jQuery util */
/* eslint-disable strict, no-undef, no-underscore-dangle, no-unused-vars */
sap.ui.controller("controllers.sumui.setpasswords_mig", {

    onInit: function(evt) {
        this.view = this.getView();
        this.page = this.view.byId("page");

        this.oDiagBox = this.view.byId("oDiagBox");
        this.oSaveBtn = this.view.byId("oSaveBtn");
        this.oCancelBtn = this.view.byId("oCancelBtn");

        this._loadFragment();
    },

    _loadFragment: function() {
        var that = this;
        var callback = function() {
            that.oSaveBtn.setVisible(true);
            that.oCancelBtn.setVisible(true);
        };
        UILoadXMLFileFragment(this.view, this.oDiagBox, "../doc/analysis/DIAG_PASSWD_MIG.XML", callback);
    },

    onBeforeRendering: function(evt) {
        this.data = evt.getSource().getViewData();
        util.UiFactory.fillPageHeader(this.page, this.view, this.data.desc);                                
    },

    handleSubmit: function() {
        var entries = UIFindValuesAndRemControls(this.oDiagBox);
        UIPostPasswords(entries);
    },

    handleCancel: function() {
        var entries = UIFindValuesAndRemControls(this.oDiagBox);
        for(var i = 0 ; i < entries.length ; i++)
            entries[i].object.setValue("");
    }
});
