sap.ui.controller("controllers.sumui.setprocpar", {
	

	onInit: function(evt) {
		// get the page
		this.view = this.getView();
		this.page = this.view.byId("page");
		this.tab = this.view.byId("ProcParTab");
		this.oJSONModel = new sap.ui.model.json.JSONModel();
		this.view.setModel(this.oJSONModel);
		this.data = evt.getSource().getViewData();
		this.url = location.href.slice(0, location.href.indexOf("slui_ext")).replace("lmsl","slp")+this.data.uri+"?xsl=0&all";
		this.parAbapUP = 		"";
		this.parAbapDOWN = 		"";
		this.parDdlUP = 		"";
		this.parDdlDOWN = 		"";
		this.parR3transUP = 	"";
		this.parR3transDOWN = 	"";
		this.parR3loadUP = 		"";
		this.parR3loadDOWN = 	"";
		this.parBatchDistr = 	"";
		var ProcParTable = [{Param: "ABAP Processes", Uptime: this.parAbapUP,  Downtime: this.parAbapDOWN}, {Param: "SQL Processes", Uptime: this.parDdlUP,  Downtime: this.parDdlDOWN}, {Param: "R3trans Processes", Uptime: this.parR3transUP,  Downtime: this.parR3transDOWN}, {Param: "R3load Processes", Uptime: this.parR3loadUP,  Downtime: this.parR3loadDOWN}];
		this._setModel(ProcParTable, "", "");
        
        this._oReconfigName = ["RECONFIG_SHD", "RECONFIG_TMP"];
		this._oReconfigGroup = [this.view.byId("oReconfigShadowGroup"), this.view.byId("oReconfigTmpGroup")];
		this._oReconfig = [this.view.byId("oReconfigShadow"), this.view.byId("oReconfigTmp")];
		this._oReconfigBusy = [this.view.byId("oReconfigShadowBusy"), this.view.byId("oReconfigTmpBusy")];
		this._oReconfigStatus = [this.view.byId("oReconfigShadowStatus"), this.view.byId("oReconfigTmpStatus")];
        
		this._mayReconfig(0);
        this._mayReconfig(1);
		
		var that = this;
		this._intervalId = setInterval(function() {
			that._mayReconfig(0);
            that._mayReconfig(1);
		}, 5000);
	},
	
	_setModel: function(table, profilePath, profileName) {
		this.oJSONModel.setData({
			table: table,
			profilePath: profilePath,
			profileName: profileName
		});
	},
	
	_getParameterValue: function(xmlNode, property) {
		return $(xmlNode).find("Parameter:has(id:contains('" + property + "'))").find("value").text();
	},
	
	_setReconfigStatus: function(id, type) {
		if(type === 0) {
			this._oReconfigStatus[id].setText("not running");
			this._oReconfigStatus[id].setState(sap.ui.core.ValueState.None);
		}
		else if(type == 1) {
			this._oReconfigStatus[id].setText("running");
			this._oReconfigStatus[id].setState(sap.ui.core.ValueState.Success);
		}
		else {
			this._oReconfigStatus[id].setText("aborted");
			this._oReconfigStatus[id].setState(sap.ui.core.ValueState.Error);
		}
	},
	
	_mayReconfig: function(id) {
		$.ajax({
			url: "../daemon/" + this._oReconfigName[id] + "?xsl=0",
			type: "GET",
			dataType: "text",
			cache: false,
			context: [this, id],

			error: function() {
				this[0]._oReconfig[this[1]].setEnabled(false);
				this[0]._oReconfigGroup[this[1]].setVisible(false);
				this[0]._oReconfigBusy[this[1]].setVisible(false);
				this[0]._setReconfigStatus(this[1], 0);
			},
			
			success: function(data) {
				var xmlData = $.parseXML(data);
				var isStopped = $(xmlData).find("Daemon[status='RUNNING']").length == 0 && $(xmlData).find("Daemon[status='STARTING']").length == 0 ? true : false;
				var isAborted = $(xmlData).find("Daemon[status='ABORTED']").length > 0 ? true : false;
				this[0]._oReconfigGroup[this[1]].setVisible(true);
				this[0]._oReconfig[this[1]].setEditable(isStopped);
				this[0]._oReconfigBusy[this[1]].setVisible(!isStopped);
				this[0]._setReconfigStatus(this[1], isAborted === true ? 2 : isStopped === true ? 0 : 1);
			}
		});
	},

	readValues: function(fnOnSuccess) {
		this.fnOnSuccess = fnOnSuccess;
		$.ajax({type: "GET",
			// first do a GET on the /parallel_processes resource
			url: this.url,
			dataType: "text",
			cache: false,
			error: $.proxy(function (xhr, options, errorText) {
				this.page.setBusy(false);
				sap.m.MessageToast.show(this.data.desc+" currently not available!");
			}, this),
			success: $.proxy(function (xml) {
				var tempDoc = $.parseXML(xml);
				if (this.fnOnSuccess) this.fnOnSuccess(tempDoc); 
			}, this)});
	},
	
	onAfterRendering: function(evt) {
		evt.getSource().getControlsByFieldGroupId("num").forEach(function(oCntr) {oCntr.setValueState(sap.ui.core.ValueState.None);});
		this.readValues(function(tempDoc) {
			var procParTable = [	{Param: "ABAP Processes", 		Uptime: this.parAbapUP = this._getParameterValue(tempDoc, "BatchProcesses:UPTIME"),
																	Downtime: this.parAbapDOWN = this._getParameterValue(tempDoc, "BatchProcesses:DOWNTIME")},
									{Param: "SQL Processes", 		Uptime: this.parDdlUP = this._getParameterValue(tempDoc, "DDLProcesses:UPTIME"),
																	Downtime: this.parDdlDOWN = this._getParameterValue(tempDoc, "DDLProcesses:DOWNTIME")},
									{Param: "R3trans Processes", 	Uptime: this.parR3transUP = this._getParameterValue(tempDoc, "R3transProcesses:UPTIME"),
																	Downtime: this.parR3transDOWN = this._getParameterValue(tempDoc, "R3transProcesses:DOWNTIME")}, 
									{Param: "R3load Processes", 	Uptime: this.parR3loadUP = this._getParameterValue(tempDoc, "R3loadProcesses:UPTIME"),
																	Downtime: this.parR3loadDOWN = this._getParameterValue(tempDoc, "R3loadProcesses:DOWNTIME")}
			];
			
			var profilePath = this._getParameterValue(tempDoc, "ShadowProfilePath");
			var profileName = this._getParameterValue(tempDoc, "ShadowProfileName");
			
			this._setModel(procParTable, profilePath, profileName);
		
			this.parBatchDistr = this._getParameterValue(tempDoc, "BatchInstance");
			if (this.parBatchDistr === "") this.parBatchDistr = "AUTO";
			if (this.parBatchDistr === "AUTO") {
				this.byId("auto").setSelected(true);
				this.byId("dedi").setSelected(false);			
				this.byId("server").setEnabled(false);
			} else { 
				this.byId("auto").setSelected(false);
				this.byId("dedi").setSelected(true);			
				this.byId("server").setEnabled(true).setValue(this.parBatchDistr);
			}
		});
	},

    onBeforeRendering: function(evt) {
		util.UiFactory.fillPageHeader(this.page, this.view, this.data.desc);                                
    },
    
    changeRadio: function(evt) {
    	var radi = evt.getSource().getId();
    	this.byId("server").setEnabled(radi.slice(radi.length-4) === "dedi");
    	this.resetState();
    },
    
    resetState: function() {
    	this.byId("server").setValueState(sap.ui.core.ValueState.None);
    },

	validateNum: function(evt) {
		var inp = evt.getSource().getValue();
		if (isNaN(inp) || (parseInt(inp) !== parseFloat(inp))) evt.getSource().setValueState(sap.ui.core.ValueState.Error).focus();
		else evt.getSource().setValueState(sap.ui.core.ValueState.None);
	},
    
	handleSubmit: function() {
		this.readValues(function(tempDoc){
			var act = {};
			act.parAbapUP = this._getParameterValue(tempDoc, "BatchProcesses:UPTIME"); 
			act.parAbapDOWN = this._getParameterValue(tempDoc, "BatchProcesses:DOWNTIME");
			act.parDdlUP = this._getParameterValue(tempDoc, "DDLProcesses:UPTIME");
			act.parDdlDOWN = this._getParameterValue(tempDoc, "DDLProcesses:DOWNTIME");
			act.parR3transUP = this._getParameterValue(tempDoc, "R3transProcesses:UPTIME");
			act.parR3transDOWN = this._getParameterValue(tempDoc, "R3transProcesses:DOWNTIME");
			act.parR3loadUP = this._getParameterValue(tempDoc, "R3loadProcesses:UPTIME");
			act.parR3loadDOWN = this._getParameterValue(tempDoc, "R3loadProcesses:DOWNTIME");
			act.parBatchDistr = this._getParameterValue(tempDoc, "BatchInstance");
			if (act.parBatchDistr === "") act.parBatchDistr = "AUTO";
			if (    (this.parAbapUP != act.parAbapUP) || (this.parAbapDOWN != act.parAbapDOWN)
				 || (this.parDdlUP != act.parDdlUP) || (this.parDdlDOWN != act.parDdlDOWN)
				 || (this.parR3transUP != act.parR3transUP) || (this.parR3transDOWN != act.parR3transDOWN)
				 || (this.parR3loadUP != act.parR3loadUP) || (this.parR3loadDOWN != act.parR3loadDOWN)     
				 || (this.parBatchDistr != act.parBatchDistr)												) {
				sap.m.MessageToast.show("Someone else has already modified the "+this.data.desc+"!");
				this.oView.rerender();
				return;
			}
			
			var table = this.oJSONModel.getData().table;
			
			if (		isNaN(act.parAbapUP = table[0].Uptime)  
					  + isNaN(act.parAbapDOWN = table[0].Downtime) 
					  + isNaN(act.parDdlUP = table[1].Uptime) 
					  + isNaN(act.parDdlDOWN = table[1].Downtime)
					  + isNaN(act.parR3transUP = table[2].Uptime) 
					  + isNaN(act.parR3transDOWN = table[2].Downtime) 
					  +	isNaN(act.parR3loadUP = table[3].Uptime) 
					  + isNaN(act.parR3loadDOWN = table[3].Downtime) 	){
				sap.m.MessageToast.show("Please check invalid entries!"); 
				return;
			}
			act.parBatchDistr = this.byId("auto").getSelected() ? "AUTO" : this.byId("server").getValue();
			var newDoc = $.parseXML("<config/>");
			var newPar = $.parseXML("<Parameter><id>_ID_</id><type>slp.parameter.type.SCALAR</type><structure/><default/><required>0</required><secure>0</secure><value></value><tuplevalue/><tablevalue/><validationResult/><valueRestrictions/></Parameter>");
			if (this.parAbapUP != act.parAbapUP) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('BatchProcesses:UPTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("BatchProcesses:UPTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('BatchProcesses:UPTIME'))").find("value").text(act.parAbapUP);
			}
			if (this.parAbapDOWN != act.parAbapDOWN) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('BatchProcesses:DOWNTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("BatchProcesses:DOWNTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('BatchProcesses:DOWNTIME'))").find("value").text(act.parAbapDOWN);
			}
			if (this.parDdlUP != act.parDdlUP) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('DDLProcesses:UPTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("DDLProcesses:UPTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('DDLProcesses:UPTIME'))").find("value").text(act.parDdlUP);
			}
			if (this.parDdlDOWN != act.parDdlDOWN) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('DDLProcesses:DOWNTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("DDLProcesses:DOWNTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('DDLProcesses:DOWNTIME'))").find("value").text(act.parDdlDOWN);
			}
			if (this.parR3transUP != act.parR3transUP) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('R3transProcesses:UPTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("R3transProcesses:UPTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('R3transProcesses:UPTIME'))").find("value").text(act.parR3transUP);
			}
			if (this.parR3transDOWN != act.parR3transDOWN) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('R3transProcesses:DOWNTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("R3transProcesses:DOWNTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('R3transProcesses:DOWNTIME'))").find("value").text(act.parR3transDOWN);
			}
			if (this.parR3loadUP != act.parR3loadUP) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('R3loadProcesses:UPTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("R3loadProcesses:UPTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('R3loadProcesses:UPTIME'))").find("value").text(act.parR3loadUP);
			}
			if (this.parR3loadDOWN != act.parR3loadDOWN) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('R3loadProcesses:DOWNTIME'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("R3loadProcesses:DOWNTIME").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('R3loadProcesses:DOWNTIME'))").find("value").text(act.parR3loadDOWN);
			}
			if (this.parBatchDistr != act.parBatchDistr) {
				if (!act.parBatchDistr) {
					sap.m.MessageToast.show("Please specify a server!"); 
					this.byId("server").setValueState(sap.ui.core.ValueState.Error); 
					return;
				}
				var temp = $(tempDoc).find("Parameter:has(id:contains('BatchInstance'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("BatchInstance").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('BatchInstance'))").find("value").text(act.parBatchDistr);
			}

			//deactivate autonext in batchconfig
			var temp = $(tempDoc).find("Parameter:has(id:contains('httpsrv/autonext'))");
			if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("httpsrv/autonext").parent();
			$(newDoc).find("config").append(temp.clone()); 
			$(newDoc).find("Parameter:has(id:contains('httpsrv/autonext'))").find("value").text(0);

			// translate DOM into string
			var xmlSer = new XMLSerializer();
			var serialXML = xmlSer.serializeToString(newDoc);

			doPost(function(xml){sap.m.MessageToast.show(this.data.desc+" stored."); this._checkDoReconfig(0); this._checkDoReconfig(1); setTimeout($.proxy(function(){this.getView().rerender();}, this), 1000);}, function(xhr, options, errorText){sap.m.MessageToast.show(this.data.desc+" currently not available!");}, this.url, serialXML, this);
		});
	},
    
    _checkDoReconfig: function(id) {
        if (this._oReconfigGroup[id].getVisible() && this._oReconfig[id].getEditable() && this._oReconfig[id].getSelected()) {
            this._doReconfig(id);
        }
    },
	
	_doReconfig: function(id) {
		this._id = id;
		doPost(
			function(data) {
				this._oReconfig[this._id].setEditable(false);
				this._oReconfigBusy[this._id].setVisible(true);
				this._setReconfigStatus(this._id, 1);
				sap.m.MessageToast.show("Reconfiguration of Instance has been started");
			},
			function() {
				this._oReconfig[this._id].setEditable(true);
				this._oReconfigBusy[this._id].setVisible(false);
				this._setReconfigStatus(this._id, 2);
				sap.m.MessageToast.show("Error: Reconfiguration of Instance failed!");
			},
			"../daemons?xsl=0", 
			'<SAPup type="daemon"><Daemon name="' + this._oReconfigName[id] + '" request="START" /></SAPup>', 
			this
		);

/*		$.ajax({
			url: "../daemons?xsl=0",
			type: "POST",
			dataType: "text",
			context: [this, id],
			data: '<SAPup type="daemon"><Daemon name="' + this._oReconfigName[id] + '" request="START" /></SAPup>',
			
			error: function() {
				this[0]._oReconfig[this[1]].setEditable(true);
				this[0]._oReconfigBusy[this[1]].setVisible(false);
				this[0]._setReconfigStatus(this[1], 2);
				sap.m.MessageToast.show("Error: Reconfiguration of Instance failed!");
			},
			
			success: function(data) {
				this[0]._oReconfig[this[1]].setEditable(false);
				this[0]._oReconfigBusy[this[1]].setVisible(true);
				this[0]._setReconfigStatus(this[1], 1);
				sap.m.MessageToast.show("Reconfiguration of Instance has been started");
			}
		});
*/
	},
	
	handleCancel: function() {
		this.getView().rerender();
		this.resetState();
	},
	
	onExit: function(oEvent) {
		clearInterval(this._intervalId);
		this.page.destroy();
		delete this.page;
	}
});
