sap.ui.controller("controllers.sumui.setshdpar", {
	
	onInit: function(evt) {
		// get the page
		this.view = this.getView();
		this.page = this.view.byId("page");
		this.data = evt.getSource().getViewData();
		this.ABAPShadowInstanceNumber = "";
		this.url = location.href.slice(0, location.href.indexOf("slui_ext")).replace("lmsl","slp")+this.data.uri+"?xsl=0&all";
	},                

	readValues: function(fnOnSuccess) {
		this.fnOnSuccess = fnOnSuccess;
		$.ajax({type: "GET",
			// first do a GET on the /parallel_processes resource
			url: this.url,
			dataType: "text",
			cache: false,
			error: $.proxy(function (xhr, options, errorText) {
				this.page.setBusy(false);
				sap.m.MessageToast.show(this.data.desc+" currently not available!");
			}, this),
			success: $.proxy(function (xml) {
				var tempDoc = $.parseXML(xml);
				if (this.fnOnSuccess) this.fnOnSuccess(tempDoc); 
			}, this)});
	},
	
	onAfterRendering: function(evt) {
		evt.getSource().getControlsByFieldGroupId("num").forEach(function(oCntr) {oCntr.setValueState(sap.ui.core.ValueState.None);});
		this.readValues(function(tempDoc){
			this.byId("ABAPShadowInstanceNumber").setValue(this.ABAPShadowInstanceNumber = $(tempDoc).find("Parameter:has(id:contains('ABAPShadowInstanceNumber'))").find("value").text());
		});
	},

    onBeforeRendering: function(evt) {
		util.UiFactory.fillPageHeader(this.page, this.view, this.data.desc);                                
    },
    
	validateNum: function(evt) {
		var inp = evt.getSource().getValue();
		if (isNaN(inp)) evt.getSource().setValueState(sap.ui.core.ValueState.Error).focus();
		else evt.getSource().setValueState(sap.ui.core.ValueState.None);
	},
    
    handleSubmit: function() {
    	this.readValues(function(tempDoc){
    		var act = {};
    		act.ABAPShadowInstanceNumber = $(tempDoc).find("Parameter:has(id:contains('ABAPShadowInstanceNumber'))").find("value").text(); 
    		if (this.ABAPShadowInstanceNumber != act.ABAPShadowInstanceNumber) {
    			sap.m.MessageToast.show("Someone else has already modified the "+this.data.desc+"!");
    			this.oView.rerender();
    			return;
    		}
			if (isNaN(act.ABAPShadowInstanceNumber = this.byId("ABAPShadowInstanceNumber").getValue())){
				sap.m.MessageToast.show("Please check invalid entries!"); 
				return;
			}
			var newDoc = $.parseXML("<config/>");
			var newPar = $.parseXML("<Parameter><id>_ID_</id><type>slp.parameter.type.SCALAR</type><structure/><default/><required>0</required><secure>0</secure><value>_VAL_</value><tuplevalue/><tablevalue/><validationResult/><valueRestrictions/></Parameter>");
			if (this.ABAPShadowInstanceNumber != act.ABAPShadowInstanceNumber) {
				var temp = $(tempDoc).find("Parameter:has(id:contains('ABAPShadowInstanceNumber'))");
				if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("ABAPShadowInstanceNumber").parent();
				$(newDoc).find("config").append(temp.clone()); 
				$(newDoc).find("Parameter:has(id:contains('ABAPShadowInstanceNumber'))").find("value").text(act.ABAPShadowInstanceNumber);
			}

			//deactivate autonext in batchconfig
			var temp = $(tempDoc).find("Parameter:has(id:contains('httpsrv/autonext'))");
			if (!temp[0]) temp = $(newPar).find("Parameter").find("id").text("httpsrv/autonext").parent();
			$(newDoc).find("config").append(temp.clone()); 
			$(newDoc).find("Parameter:has(id:contains('httpsrv/autonext'))").find("value").text(0);

			// translate DOM into string
			var xmlSer = new XMLSerializer();
			var serialXML = xmlSer.serializeToString(newDoc);

        	doPost(function(xml){sap.m.MessageToast.show(this.data.desc+" stored."); setTimeout($.proxy(function(){this.getView().rerender();}, this), 1000);}, function(xhr, options, errorText){sap.m.MessageToast.show(this.data.desc+" currently not available!");}, this.url, serialXML, this);
    	});
    },
	
	handleCancel: function() {
		this.getView().rerender();
	}	   
});
