/* update routine for XML Model R3LoadBuckets */

// ================================================================
// Here, the R3Load Data is loaded...
// 
// ================================================================

var gFilterFinished = true;
var gFilterRescheduled = true;
var gFilterRunning = true;
var gAutoRefresh = false;
var gR3LoadRefresh;
var upperLimPrc = 100;
var gNumTotal    = 0;
var gNumFinished = 0;
var gNumRunning  = 0;
var gNumResched  = 0;
var gNumFailed   = 0;
	
function makeReadable(valueStr){
	return valueStr ? valueStr : "0";
}

function updateModelR3LoadBuckets(view) {
// load the status resource into the internal data model R3LoadBuckets used by the table control   
    if (view === undefined) {
        sap.m.MessageBox.error("No view defined!");
    }
    var oModel = view.getModel("R3LoadBuckets");    
//    oModel.loadData("./buckets.xml");
    $.ajax({
        type: "GET",
        url: "../status?details=1&xsl=0",
        dataType: "text",
        cache: false,
        success: function (xml)
        {
//          xml = xml.replace(/%3a/g, "___");  // sanitizer?
            oModel.setXML(xml);
            oModel.refresh(true);
            gNumFinished = Math.random()*1000;
            xml = $.parseXML(xml);
            gNumTotal    = parseInt(makeReadable($(xml).find("Cloning").attr("totalprocs")));
            gNumFinished = parseInt(makeReadable($(xml).find("Cloning").attr("finishedprocs")));
            gNumRunning  = parseInt(makeReadable($(xml).find("Cloning").attr("exportprocs"))) + parseInt(makeReadable($(xml).find("Cloning").attr("impprocs")));
            gNumResched  = parseInt(makeReadable($(xml).find("Cloning").attr("restartedprocs")));
            gNumFailed   = parseInt(makeReadable($(xml).find("Cloning").attr("failedprocs")));            
            view.byId("R3LoadBuckets").getFooter().setText(composeBucketSummary()); // summary line
        },
        error: function (xhr, options, errorText)
        {
        }
    });
}

function composeBucketSummary() {
// compose summary line under bucket table
	return "Process Statistics - Planned: "+gNumTotal+" / Finished: "+gNumFinished+" / Running: "+gNumRunning+" / Rescheduled: "+gNumResched+" / Failed: "+gNumFailed;
}

function autoUpdateModelR3LoadBuckets(view, status) {
// load the status resource into the internal data model R3LoadBuckets used by the table control
  //self = view;
  if (status){
      gAutoRefresh = status;
      gR3LoadRefresh = setInterval(function() {updateModelR3LoadBuckets(view);}, 5000);
  } else {
      clearInterval(gR3LoadRefresh);
  }
}

function setStatusRestartButton(view) {
// helper function to set the status (enabled/disabled) of the restart button depending on whether items are selected or not
// and to set the status of the AutoRefresh-Button (pressed/not pressed))
    var table = view.byId("R3LoadBuckets");
    view.byId("R3LoadBucketsAutoRefresh").setPressed(gAutoRefresh);    
    var bucketRefIds = table.getSelectedIndices();
    view.byId("R3LoadBucketsRestart").setEnabled(bucketRefIds.length > 0);
}

function setFilter(state, status) {
// takes over the filter settings from the UI
    switch (state) {
        case "finished":
            gFilterFinished = status;
            break;
        case "rescheduled":
            gFilterRescheduled = status;
            break;
        case "running":
            gFilterRunning = status;
            break;
        default:
            sap.m.MessageBox.error("Error applying filter!");
    }
}

var gExpStatus = false;  // global flag to communicate from handleFilter export --> import
function handleFilter(oValue, bExport) {
// filter function for the export (bExport==true) and import (bExport==false) status
// used in the model binding when sorted by common status
    if (bExport) gExpStatus = false;   // reset flag since new bucket is evaluated, first call: export status
    switch (oValue) {
        case "FINISHED":
            gExpStatus = gFilterFinished;
            return bExport?false:gFilterFinished;
        case "RUNNING":
            return gFilterRunning;
        case "RESCHEDULED":
        case "TERMINATED":
        case "RESTARTING":
            return gFilterRescheduled;
        case "ERROR": 
        case "FAILED":
            return true;
        default:
            return bExport?false:gExpStatus;
    }
}

function closeDialog(oControlEvent) {
// handles the close button in the log display dialog
    oControlEvent.getSource().getParent().close();
}

function restartR3LoadBucket(bucketRefIds, view) {
// helper function for restarting the set of selected buckets
    $.ajax({type: "GET",
        // first do a GET on the FAILED_BUCKETS resource i.o.t. double-check whether a bucket needs restart
        url: "../parallel_processes?xsl=0",
        dataType: "text",
        cache: false,
        error: function (xhr, options, errorText) {
            updateModelR3LoadBuckets(view);
        },
        success: function (xml) {
            var tempDoc = $.parseXML(xml);
            var bucketCnt = 0;
            // flag the selected FailedBucket elements for being relaunched
            bucketRefIds.forEach(function (bucketRefId) {
                $(tempDoc).find("FailedBucket").filter(function (index) {
                    return $(this).text() === bucketRefId;
                }).attr("enabled", "true").removeAttr("comment");
                bucketCnt += 1;
            });
            // remove all FailedBucket elements which are NOT selected for relaunch from the DOM (as needed by SAPup)
            $(tempDoc).find("FailedBucket").filter(function (index) {
                return $(this).attr("enabled") === "false";
            }).remove();
            // translate DOM into string
            var xmlSer = new XMLSerializer();
            var serialXML = xmlSer.serializeToString(tempDoc);
            // now put the stuff back to SAPup

        	doPost(
	        	function (xml) {
                    updateModelR3LoadBuckets(view);
                    sap.m.MessageToast.show("" + bucketCnt + " bucket" + (bucketCnt === 1 ? "" : "s") + " rescheduled.");
                }, 
	        	function (xhr, options, errorText) {
                    updateModelR3LoadBuckets(view);
                }, 
	        	"../parallel_processes", 
	        	serialXML, 
	        	this
        	);

/*          $.ajax({type: "POST",
                url: "../parallel_processes",
                data: serialXML,
                contentType: "application/xml",
                dataType: "text",
                cache: false,
                error: function (xhr, options, errorText) {
                    updateModelR3LoadBuckets(view);
                },
                success: function (xml) {
                    updateModelR3LoadBuckets(view);
                    sap.m.MessageToast.show("" + bucketCnt + " bucket" + (bucketCnt === 1 ? "" : "s") + " rescheduled.");
                }
            });
*/
        }
    });
}

function getProcessLimit() {   
	// helper function for getting process parameter currprocesses
		this.sliderGrab = -1;
	    $.ajax({type: "GET",
	        // first do a GET on the /parallel_processes resource
	        url: "../parallel_processes?xsl=0",
	        dataType: "text",
	        cache: false,
	        async: false,
	        error: function (xhr, options, errorText) {
	        },
	        success: $.proxy(function (xml) {
	            var tempDoc = $.parseXML(xml);
	            // find param
	            var parProc = $(tempDoc).find("ParallelProcesses").attr("currprocesses");
	            this.sliderGrab = parseInt((parProc === undefined) ? "0" : parProc);
	        }, this)
	    });
	    return this.sliderGrab;
	}

function setProcessLimits(view, lim, sliderGrabbed) {   
// helper function for setting process parameters
	this.view = view;
	this.lim = lim;
	this.sliderGrabbed = sliderGrabbed; 			//the value of currprocesses at the point of time when the slider was grabbed
    $.ajax({type: "GET",
        // first do a GET on the /parallel_processes resource
        url: "../parallel_processes?xsl=0",
        dataType: "text",
        cache: false,
        error: function (xhr, options, errorText) {
        },
        success: $.proxy(function (xml) {
            var tempDoc = $.parseXML(xml);
            // find param
            var parProc = $(tempDoc).find("ParallelProcesses").attr("currprocesses");
            var value = parseInt((parProc === undefined) ? "0" : parProc);
            if ((value > 0) && (value === this.sliderGrabbed)) { 						//value still not changed from outside?
                var maxProc = $(tempDoc).find("ParallelProcesses").attr("maxprocesses");
                upperLimPrc = parseInt((maxProc === undefined) ? value : maxProc);
                this.maxValueSld = parseInt(this.lim*1.5);
                if (this.maxValueSld < 4) {this.maxValueSld = 4;}
                if (this.maxValueSld > upperLimPrc) {this.maxValueSld = upperLimPrc;} 
                if (parProc === this.lim) return;
                $(tempDoc).find("ParallelProcesses").attr("currprocesses",this.lim); 
            	// translate DOM into string
            	var xmlSer = new XMLSerializer();
            	var serialXML = xmlSer.serializeToString(tempDoc);
            	// now put the stuff back to SAPup

	        	doPost(
		        	function(){this.view.byId("R3LoadPrcSld").setMax(Math.ceil(this.maxValueSld/10)*10);},
		        	function(){}, 
		        	"../parallel_processes", 
		        	serialXML, 
		        	this
	        	);

/*            	$.ajax({type: "POST",
            		url: "../parallel_processes",
            		data: serialXML,
            		contentType: "application/xml",
            		dataType: "text",
            		cache: false,
            		error: function (xhr, options, errorText) {
            		},
            		success: $.proxy(function (xml) {
                        this.view.byId("R3LoadPrcSld").setMax(Math.ceil(this.maxValueSld/10)*10);
            		}, this)  
            	});
*/ 
            }
        }, this)
    });
    return lim;
}

function initProcessLimits(view) {   
// helper function for setting process parameters
	this.view = view;
    $.ajax({type: "GET",
        // first do a GET on the /parallel_processes resource
        url: "../parallel_processes?xsl=0",
        dataType: "text",
        cache: false,
        error: function (xhr, options, errorText) {
        },
        success: $.proxy(function (xml) {
            var tempDoc = $.parseXML(xml);
            // find param
            var label = $(tempDoc).find("ParallelProcesses").attr("label");
            if (label === undefined) label = "";
			showPrcCntr(this.view, label !== "");
            var parProc = $(tempDoc).find("ParallelProcesses").attr("currprocesses");
            var value = parseInt((parProc === undefined) ? 0 : parProc);
            if (value > 0) {
                var maxProc = $(tempDoc).find("ParallelProcesses").attr("maxprocesses");
                upperLimPrc = parseInt((maxProc === undefined) ? value : maxProc);
                var maxValueSld = value*1.5;
                if (maxValueSld < 4) maxValueSld = 4;
                if (maxValueSld > upperLimPrc) maxValueSld = upperLimPrc; 
/*                if (value > maxValueSld) {  // caution: this can happen if a module is repeated and new maxprocesses is lower than currprocesses 
                	value = maxValueSld;
                	this.setProcessLimits(this.view, value, value);  
                }
*/
//                if (document.activeElement.id.indexOf("R3LoadPrc") < 0) {
                	this.view.byId("R3LoadPrcSld").setMax(Math.ceil(maxValueSld/10)*10);
                	this.view.byId("R3LoadPrcSld").setValue(value);
                	this.view.byId("R3LoadPrcInp").setValue(value);
//                }
            }
        	this.view.byId("R3LoadSldLbl").setText(label+" Process Limit");
        	this.view.byId("R3LoadSldLbl").setTooltip(this.view.byId("R3LoadSldLbl").getText());
        	this.view.byId("R3LoadPrcSld").setTooltip(this.view.byId("R3LoadSldLbl").getText() + ": " + value);
        	this.view.byId("R3LoadPrcInp").setTooltip(this.view.byId("R3LoadSldLbl").getText() + ": " + value);
        }, this)
    });
}

function stopProcesses(kill) {
    $.ajax({type: "GET",
        // first do a GET on the /parallel_processes resource
        url: "../parallel_processes?xsl=0",
        dataType: "text",
        cache: false,
        error: function (xhr, options, errorText) {
        },
        success: $.proxy(function (xml) {
            var tempDoc = $.parseXML(xml);
            this.kill = kill;
            if (kill) 	$(tempDoc).find("ParallelProcesses").attr("kill",true);
       	    else 	$(tempDoc).find("ParallelProcesses").attr("stop",true);        	    
            // translate DOM into string
            var xmlSer = new XMLSerializer();
            var serialXML = xmlSer.serializeToString(tempDoc);
            // now put the stuff back to SAPup

        	doPost(
	        	function(){sap.m.MessageToast.show("All processes " + ((this.kill) ? "killed" : "stopped") + ".");},
	        	function(){}, 
	        	"../parallel_processes", 
	        	serialXML, 
	        	this
        	);

/*          $.ajax({type: "POST",
            	url: "../parallel_processes",
            	data: serialXML,
            	contentType: "application/xml",
            	dataType: "text",
            	cache: false,
            	error: function (xhr, options, errorText) {
            	},
            	success: $.proxy(function (xml) {
                    sap.m.MessageToast.show("All processes " + ((this.kill) ? "killed" : "stopped") + ".");
            	}, this)  
            });
*/             
        }, this)
    });   
}

function applyStatusSort(oBinding) {
// helper function to apply the sorter for the status column in the model binding
    var aSorter = [];
    var oSorter = new sap.ui.model.Sorter("@export");
    oSorter.fnCompare = function (a, b) {
        var map = {"FINISHED": 0, "RUNNING": 1, "RESTARTING": 2, "TERMINATED": 3, "RESCHEDULED": 4};
        function get(k) {
            return (map[k] === undefined) ? 5 : map[k];
        }
        if (get(a) === get(b)) {
            return 0;
        }
        if (get(a) < get(b)) {
            return 1;
        }
        if (get(a) > get(b)) {
            return -1;
        }
    };

    aSorter.push(oSorter);
    oSorter.sPath = "@import";
    aSorter.push(oSorter);

    oBinding.sort(aSorter);
}

function showPrcCntr(view, enable) {
	view.byId("R3LoadSldLbl").setVisible(enable);	
	view.byId("R3LoadPrcSld").setVisible(enable);
	view.byId("R3LoadPrcInp").setVisible(enable);
}
