/* Call multiple async threads and wait until all threads are finished */
function UICallWaitForAsyncThreads(funcToCall, jobs, finalcallback, that) {

	var cont = {};
	cont.jobs = jobs;
	cont.finalcallback = finalcallback;
	cont.that = that;

	cont.results = [];
	for(var i = 0 ; i < jobs.length ; i++) {
		cont.results[i] = null;
	}
	
	cont.nExpectedResults = jobs.length;
	cont.nResults = 0;
	
	var callAsyncThread = function(data, wrapper) {
		var cont = wrapper.cont;
		var id = wrapper.id;
		
		cont.results[id] = data;
		cont.nResults += 1;
		
		if(cont.nResults == cont.nExpectedResults) {
			cont.finalcallback(cont.results, cont.that);
		}
	};
	
	for(var i = 0 ; i < jobs.length ; i++) {
		var wrapper = {};
		wrapper.cont = cont;
		wrapper.id = i;
		funcToCall(jobs[i], callAsyncThread, wrapper);
	}
}

/* ****************************************************************************** */

/* Check if file exists */
function UiCheckFileExists(file, callback, that) {
	var path = file.url;
	
	var cont = {};
	cont.file = file;
	cont.callback = callback;
	cont.that = that;
	
	$.ajax({
		url: path,
		type: "HEAD",
		cache: false,
		context: cont,
		
		error: function() {
			this.callback(null, this.that);
		},
		success: function() {
			this.callback(this.file, this.that);
		}
	});
}

/* ****************************************************************************** */

/* Get existing files from JSON */
function UIGetFilesFromJSON(jsonPath, string, callback, finalcallback, that) {
	
	var cont = {};
	cont.string = string;
	cont.callback = callback;
	cont.finalcallback = finalcallback;
	cont.that = that;
	
	return $.ajax({
		url: jsonPath,
		type: "GET",
		dataType: "json",
		cache: false,
		context: cont,
		
		error: function() {
			this.callback(null, this.that);
		},
		
		success: function(data) {
			var cont = this;
			var jobs = [];
			var id = cont.string;
			for(var i = 0 ; i < data[id].length ; i++) {
	        	var file = {};
	        	file.name = data[id][i].name;
	        	file.url = data[id][i].url;
	        	jobs.push(file);
	        }
			
			var allThreadsFinished = function(results, cont) {
				for(var i = 0 ; i < results.length ; i++) {
					cont.callback(results[i], cont.that);
				}
				cont.finalcallback(cont.that);
			};
			
			UICallWaitForAsyncThreads(UiCheckFileExists, jobs, allThreadsFinished, cont);
		}
	});
}

/* ****************************************************************************** */

/* Get existing files from JSON and add it to selector */
function UIGetFilesFromJsonAdd2Selector(jsonPath, string, oSelect, callback, that) {
	
	var cont = {};
	cont.oSelect = oSelect;
	cont.callback = callback;
	cont.that = that;
	
	var addFiles2Selector = function(file, main) {

		if(file == null) {
			return;
		}

		var item = new sap.ui.core.Item({
			key: file.url,
			text: file.name
		});
		
		main.oSelect.addItem(item);
	};
	
	var finalCallback = function(main) {
		main.callback(main.that);
	};

	return UIGetFilesFromJSON(jsonPath, string, addFiles2Selector, finalCallback, cont);
}

/* ****************************************************************************** */

/* Read CSV file line by line */
function UIReadCSVFile1(filePath, callback, commentsCallback, that) {
	var path = filePath;
	
	this.that = that;
	this.callback = callback;
	this.commentsCallback = commentsCallback;
	
	return $.ajax({
		url: path,
		type: "GET",
		cache: false,
		context: this,
		
		error: function() {
			this.callback(null, this.that);
		},
		
		success: function(data) {
			var lines = data.split('\n');
			for(var x = 0; x < lines.length; x++) {
				var line = lines[x];
				
				if(!line || line.length === 0 || !line.trim()) {
					continue;
				}
	
				if(line.startsWith("#")) {
					if(this.commentsCallback) {
						this.commentsCallback(line, this.that);
					}
					continue;
				}
				
				var data = line.split(';');
				this.callback(data, this.that);
			}
			
			this.callback(null, this.that);
		}
	});
}

/* ****************************************************************************** */

function UIReadCSVFile(filePath, callback, that) {
	return UIReadCSVFile1(filePath, callback, null, that);
}

/* ****************************************************************************** */

function UIReadXMLFile(filePath, callback, that) {
    this.that = that;
    this.callback = callback;
    
    return $.ajax({
        url: filePath,
        type: "GET",
        cache: false,
        context: this,
        
        error: function() {
            this.callback(null, this.that);
        },
        
        success: function(data) {
            this.callback(data, this.that);
        }
    }); 
}

/* ****************************************************************************** */

function UILoadXMLFileFragment(view, oBox, filePath, successCallback) {
    this.oBox = oBox;
    this.view = view;
    this.successCallback = successCallback;
    
    var loadXml = function(data, that) {
        if(data === null || data === undefined)
            return; 
        
        var xmlData = data.documentElement;
        var oFragment = sap.ui.xmlfragment({ id: "idXmlFragSAPupMain", fragmentContent: xmlData }, that.view.getController());
        that.oBox.addItem(oFragment);
        
        that.successCallback();
    };
    
    UIReadXMLFile(filePath, loadXml, this);
}

/* ****************************************************************************** */

/* Get attribute */
function UIGetAttribute(object, string, defaultValue) {
    var value = $(object).attr(string);

    if(typeof value === typeof undefined || value === false) {
        value = defaultValue;
    }
    
    return value;
}

/* Get value/content */
function UIGetValue(object, defaultValue) {
    var value = object.innerHTML;

    if(typeof value === typeof undefined || value === false) {
        value = defaultValue;
    }
    
    return value;
}

/* ****************************************************************************** */

function UICallAsyncFunction(callback, that) {
	var async = function() {
		var args = arguments;
		setTimeout(function() {
			callback(args[1]);
		}, 0);
	};
	async(callback, that);
}

/* ****************************************************************************** */

function UISetDaemonProcessStatus(daemon) {
	daemon.statusState = "None";
	daemon.requestState = "None";
	
	daemon.canStart  = true;
	daemon.canStop   = false;
	daemon.canKill   = false;
	daemon.canChange = false;
	daemon.isBusy    = false;
	
	daemon.status = daemon.status.toLowerCase();
	daemon.request = daemon.request.toLowerCase();
	
	/* Check status */
	if(daemon.status === "null") {
		daemon.status = "stopped";
	}
	else if(daemon.status == "starting") {
		daemon.statusState = "Warning";
		daemon.canStart = false;
		daemon.isBusy = true;
	}
	else if(daemon.status === "running") {
		daemon.statusState = "Success";
		daemon.canStart  = false;
		daemon.canStop   = true;
		daemon.canKill   = true;
		daemon.canChange = true;
	}
	else if(daemon.status === "detached") {
		daemon.statusState = "Error";
		daemon.canStart = false;
		daemon.canKill  = true;
	}
	else if(daemon.status === "aborted") {
		daemon.statusState = "Error";
	}
	else if(daemon.status === "killed") {
		daemon.statusState = "Error";
	}
	
	/* Check request */
	if(daemon.request !== "null") {
		daemon.canStart  = false;
		daemon.canStop   = false;
		daemon.canKill   = false;
		daemon.canChange = false;
		daemon.isBusy    = true;
	}
	
	if(daemon.request === "start") {
		daemon.status = "starting";
		daemon.statusState = "Warning";
	}
	else if(daemon.request === "stop") {
		daemon.status = "stopping";
		daemon.statusState = "Warning";
	}
	else if(daemon.request === "kill") {
		daemon.status = "killing";
		daemon.statusState = "Warning";
	}
}

/* ****************************************************************************** */

function loopRecursive(object, list) {
    
    if(typeof object !== 'object') return;
    if(typeof object.getId !== 'function') return;
    
    // ------------------------------------------------------
    
    var entry = { object: object, remId: null, remArg: null, value: null };
    
    if(typeof object.getProperty === 'function')
    {
        try { entry.remId = object.getProperty('remId'); } catch(e) { entry.remId = null; }
        try { entry.remArg = object.getProperty('remArg'); } catch(e) { entry.remArg = null; }
    }
    
    if(typeof object.getValue === 'function')
        entry.value = object.getValue();
    
    if(entry.remId !== null && entry.remId !== undefined && entry.remId !== "" &&
       entry.value !== null && entry.value !== undefined)
       list.push(entry);
    
    // ------------------------------------------------------
    
    if(typeof object.getItems === 'function')
    {
        var items = object.getItems();
        for(var i = 0 ; i < items.length ; i++)
            loopRecursive(items[i], list);
    }
    else if(typeof object.getContent === 'function')
    {
        var items = object.getContent();
        for(var i = 0 ; i < items.length ; i++)
            loopRecursive(items[i], list);
    }
}

function UIFindValuesAndRemControls(oBox) {
    var entries = [];
    loopRecursive(oBox, entries);
    return entries;
}

/* ****************************************************************************** */

function stopIntervals() {
	for ( var key in globalIntervals) {
		if (globalIntervals.hasOwnProperty(key)) {
			if (globalIntervals[key] !== 0) {
				clearInterval(globalIntervals[key]);
				globalIntervals[key] = 0;
			}
		}
	}
}

/* ****************************************************************************** */

function getURLDetails() {
    var details = {};
    details.protocol = document.URL.split("://")[0];
    details.hostname = document.URL.split("://")[1].split("/")[0];
    details.sid = document.URL.split("/")[5];
    details.toolmode = document.URL.split("/")[4];
    return details;
}

jQuery.sap.declare("util.Tools");
util.Tools = {
    xmlIFrame: function(xmlPath) {
		var ind = document.URL.indexOf("?sui");
		var ind2 = document.URL.indexOf("#");
		if (ind2 < 0) ind2 = document.URL.length;
		var path = xmlPath.split("/");
		$.get(xmlPath).fail($.proxy(function(){
			this.getParent().getHeaderContent().forEach(function(a){a.setEnabled(false);});
			this.setContent("<div style='margin: 20px'>The file '" + path[path.length-1] + "' has not yet been generated by the Software Update Manager.<br/>Please try again later. </div>");
		}, this)).done($.proxy(function(){
			this.getParent().getHeaderContent().forEach(function(a){a.setEnabled(true);});
			this.setContent("<iframe id='sum_frame' class='xmlIFrame' scrolling='yes' frameborder='0' src='" + xmlPath + ((ind > 0) ? document.URL.slice(ind, ind2) : "") + "'></iframe>");
		}, this));
	}
};

function checkFileExists(url) {
	var httpRequest = new XMLHttpRequest();
	httpRequest.open('GET', url, false);
	httpRequest.send();
	if (httpRequest.status == 404) return false;
	else return true;
}

function openHelpWindow() {
    var url = globalPathLmslAbap + "/guide/" + ((["zdo", "cnv", "doc"].indexOf(globalGuideInfo.opt.substr(0, 3)) >= 0) ? "" : ((globalGuideInfo.db ? globalGuideInfo.db : "HDB") + "/")) + (globalGuideInfo.opt ? globalGuideInfo.opt : "std") + "/" + (globalGuideInfo.loio ? globalGuideInfo.loio : "index") + ".html";
    if ((globalGuideInfo.db === "DB4") && !checkFileExists(url)) url = url.replace(/\/DB4\//, "/HDB/"); //Fallback for DB4 with Windows dialog instance, see BCP 2280113059
	if (globalGuideInfo.section && globalGuideInfo.loio) url += "#loio" + globalGuideInfo.loio + "__" + globalGuideInfo.section;
    window.open(url, "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");	
};

function doPost(succFunc, failFunc, url, payload, cntxt) {
    $.ajax({
        type: "post",
        url: url,
        dataType: "text",
        context: cntxt,
        cache: false,
        data: payload,
        success: succFunc,
        error: function(xhr, status, error) {
			switch(xhr.status) {
				case 403:	$.ajax({
								type: "get",
								url: url,
								headers: {'X-CSRF-Token': 'Fetch'},
								context: this,
								cache: false,
								success: 	function(a,b,c){
												$.ajaxSetup({headers: {'X-CSRF-Token': c.getResponseHeader('X-CSRF-Token')}});
												doPost(succFunc, failFunc, url, payload, this);
											},
								error: 		function(){}
							});
							break;
				default: 	failFunc(xhr, status, error);
			}
		}
    });
};

/* ****************************************************************************** */

function UIGetSLPUrl() {
    var fullUrl = document.location.href;
    fullUrl = fullUrl.replace("/lmsl/", "/slp/");
    
    var offset = fullUrl.indexOf("slui_ext");
    fullUrl = fullUrl.substring(0, offset);
    
    fullUrl = fullUrl.replace(/\/$/, "");
    return fullUrl;
}

/* ****************************************************************************** */

function UIGetBoolean(value) {
    return value === "true" || value === true || value === 1 ||
           value === "yes"  || value === "ok" ||
           value === "on"   || value === "1";
}

/* ****************************************************************************** */

function UIGetRemoteControls(successCallback, that) {
    var url = UIGetSLPUrl() + "/batchconfig?xsl=0&all";
    
    this.that = that;
    this.successCallback = successCallback;
    
    return $.ajax({
        url: url,
        type: "GET",
        dataType: "text",
        cache: false,
        context: this,
        error: function() {},
        success: function(data) {
            var xmlData = $.parseXML(data);
            this.successCallback(xmlData, this.that);
        }
    }); 
}

function UIGetRemoteControlValue(xmlNode, id, defaultValue) {
    var tmp = $(xmlNode).find("Parameter:has(id:contains('" + id + "'))");
    
    if(tmp !== null && tmp !== undefined)
        return $(tmp).find("value").text();
    
    return defaultValue;
}

/* ****************************************************************************** */

function UIPostRemoteControls(label, entries, filterEmpty) {
    var url = UIGetSLPUrl() + "/batchconfig";
    var data = "<config>";
    
    for(var i = 0 ; i < entries.length ; i++) {
        var entry = entries[i];
        
        if(entry.value === null || entry.value === undefined)
            continue;
        
        if(filterEmpty === true && entry.value === "")
            continue;
            
        if(entry.remId === null || entry.remId === undefined || entry.remId === "")
            continue;
        
        data += "<Parameter><id><![CDATA[" + entry.remId + "]]></id><type>slp.parameter.type.SCALAR</type><value><![CDATA[" + entry.value + "]]></value></Parameter>";
    }
    
    //deactivate autonext in batchconfig
    data += "<Parameter><id>httpsrv/autonext</id><type>slp.parameter.type.SCALAR</type><value>0</value></Parameter>";
    data += "</config>";
    
    var successCallback = function() {
        sap.m.MessageToast.show(label + " saved.");
    };
    
    var errorCallback = function() {
        sap.m.MessageToast.show(label + " could not be saved!");
    };
    
    doPost(successCallback, errorCallback, url, data, null);
}

/* ****************************************************************************** */

function UIPostPasswords(entries) {
    return UIPostRemoteControls("Password(s)", entries, true);
}
