/* global sap jQuery util */
/* eslint-disable strict */

sap.ui.jsview("views.app", {

	getControllerName: function() {
		return "controllers.app";
	},

	/*eslint-disable no-unused-vars*/
	createContent: function(oController) {
	/*eslint-enable no-unused-vars*/

		// to avoid scrollbars on desktop the root view must be set to block display
		this.setDisplayBlock(true);

		// create app
		this.app = new sap.m.SplitApp({
			afterDetailNavigate: function() {
				this.hideMaster();
			}
		});

		// add first pages only, the rest is lazy loaded
		this.app.addMasterPage(sap.ui.xmlview(util.Id.CATEGORIES, "views." + util.Id.CATEGORIES));
		if (!jQuery.device.is.phone) {
			this.app.addDetailPage(sap.ui.xmlview(util.Id.WELCOME, "views." + util.Id.WELCOME));
		}

		// done
		return new sap.m.Shell("Shell", {
			title: "Software Update Manager Utilities",
			showLogout: false,
			app: this.app
/*			homeIcon: {
				"favicon": "../slui/resources/sap/ui/core/mimes/logo/txtonly_16x16.ico",
				"precomposed": false
			}
*/
		});
	}
});
