/* Copyright (c) 2001-2014 by SAP AG, Walldorf, Germany.
 * All rights reserved. Confidential and proprietary.
 */


/**
 * This file provides the ability of specifying and using JS code within the HTML export by using
 * the JQuery library for convenience DOM modification.
 */



/**
 * Is notified when the document was completely built by the browser.
 */
$(document).ready(function() {
	// align all specified UI elements of the expandable notes
	alignUIElementsOfTheNoteByExpanding();
	
});

/**
 * This method register an listener on each <a> node in order to align specified UI elements of the 
 * expandable note controls.
 */
function alignUIElementsOfTheNoteByExpanding() {
	// listen when the link is clicked to expand or collapse
	$('a').click(function() {
		// get the expand areas
		var expandIds = $(this).attr('expand_ids');
		
		if (expandIds != null) {
			// get the IDs of the expanded elements
			$(expandIds.split(';')).each(function() {
				if (this != null && this.length > 0) {
					// for all expanded elements
					$('#'+this).each(function() {
						
						$('.note_wide', this).each(function(index) {

							if ($(this).is(':visible')) {
								var maxLength = 0;
								// first calculate the maximum width of the controls
								$('.post_align_node', $(this)).each(function(index2) {
									var nodeWidth = $(this).children(0).width();
									maxLength = Math.max(maxLength, nodeWidth);
								});
								// now set the same size to all elements
								$('.post_align_node', $(this)).each(function(index2) {
									$(this).width(maxLength + 10);
								});
							}
						});
					});
				}
			})
		}
	});
}