use SDB::Install::SysVars;
use SDB::Install::System qw (exec_program getSysPath);


our  @dlls = qw (SAPNewDBMDXProvider.dll SAPNewDBMDXProviderEr.dll);

sub Register{
	if (!$isWin){
		return 1;
	}
	my ($self) = @_;
	my $path = $self->getPath ();
	my $errlst = new SDB::Install::MsgLst ();
	my $system32 = getSysPath ($errlst);
	if (!defined $system32){
		$self->AddError ("Cannot determine system32 path", $errlst);
		return undef;
	}
	my $regsvr32 = $system32 . $path_separator . 'regsvr32.exe';
	my ($cfg, $rc);
	my $msg = $self->AddMessage ("Registering MDX provider");
	local %ENV = %ENV;
	$ENV{PATH} = $path . $env_path_separator . $ENV{PATH};
	foreach my $dll (@dlls){
		$cfg = {};
		$rc = exec_program ($regsvr32, ['/s', $path . $path_separator . $dll], $cfg);
		if (!defined $rc || $rc != 0){
			$self->PushError ("Cannot register MDX provider", $cfg);
			$self->AddSubMsgLst ($msg, $cfg);
			return undef;
		}
		$self->AddSubMsgLst ($msg, $cfg); 
	
	}
	return 1;
}


sub Unregister{
	if (!$isWin){
		return 1;
	}
	my ($self) = @_;
	my $path = $self->getPath ();
	my $errlst = new SDB::Install::MsgLst ();
	my $system32 = getSysPath ($errlst);
	if (!defined $system32){
		$self->AddError ("Cannot determine system32 path", $errlst);
		return undef;
	}
	my $regsvr32 = $system32 . $path_separator . 'regsvr32.exe';
	my ($cfg, $rc);
	my $msg = $self->AddMessage ("Unregistering MDX provider");
	local %ENV = %ENV;
	$ENV{PATH} = $path . $env_path_separator . $ENV{PATH};
	foreach my $dll (@dlls){
		$cfg = {};
		$rc = exec_program ($regsvr32, ['/u','/s', $path . $path_separator . $dll], $cfg);
		if (!defined $rc || $rc != 0){
			$self->PushError ("Cannot unregister MDX provider", $cfg);
			$self->AddSubMsgLst ($msg, $cfg);
			return undef;
		}
		$self->AddSubMsgLst ($msg, $cfg); 
	
	}
	return 1;
}

1;
