use SDB::Install::System;
use SAPDB::Install::MD5Sum;
use SDB::Install::Tools;
use SDB::Install::SysVars qw ($isWin $path_separator);

sub initPackage{
	my ($self) = @_;
	if ($self->isa ('SDB::Install::Package::Installable')){
		$self->FindKitFiles ();
		my %union = (%{$self->{data}->{files}},%{$self->{kitfiles}});
		my $tmp;
		my $size = 0;
		foreach my $key (sort keys (%union)){
			$tmp .= $union{$key}->{checksum};
			$size +=  $union{$key}->{size};
		}
		$self->{data}->{checksum} = MD5Str ($tmp);
		$self->{data}->{size} = $size;
	}
	return 1;
}

sub GetNumberOfFiles ($) {
    my ($self) = @_;
    my $nFiles = $self->SUPER::GetNumberOfFiles();

    if ($self->isa ('SDB::Install::Package::Installable') && defined $self->{kitfiles}){
        $nFiles += scalar keys %{$self->{kitfiles}};
    }
    return $nFiles;
}

sub FindKitFiles{
    my ($self) = @_;
    $self->AddMessage ('Installler is part of installation kit');
    require SDB::Install::Installer;
    my $installer = new SDB::Install::Installer ();
    my $dir;
    if ($installer->can('getInstRuntimeDir')){
       $dir = $installer->getInstRuntimeDir();
    }
    else{
       $dir = $installer->getInstallerDir() . $path_separator . 'instruntime';
    }
    my $entries = find ($dir, $self, FIND_TYPE_FILE, undef, undef, '/');
    if (!defined $entries){
        return undef;
    }
    my %filelist;
    my %filesource;
    my $prefix  = 'install'.$path_separator.'instruntime';
    my $file;
    my @statbuf;
    foreach $entry (@$entries){
        $file = $dir . $path_separator . $entry;
        @statbuf = stat ($file);
        my %info = (
                'checksum' => MD5Sum ($file),
                'size' => $statbuf [7],
                'mode' => $statbuf [2] & 07777,
                'mtime' => $statbuf [9]
                );

        $filelist{$prefix .'/'. $entry} = \%info;
        $filesource{$prefix .'/'. $entry} = $file;
    }
    if ($isWin){
        $prefix = 'install';
        my @entries;
        my $installerDir = $installer->getInstallerDir ();
        if (opendir (DH, $installerDir)){
            @entries = grep {/^msv.*\.dll$/i} readdir (DH);
            closedir (DH);
        }
        foreach $entry (@entries){
            $file = $installerDir . $path_separator . $entry;
            @statbuf = stat ($file);
            my %info = (
                'checksum' => MD5Sum ($file),
                'size' => $statbuf [7],
                'mode' => $statbuf [2] & 07777,
                'mtime' => $statbuf [9]
                );
            $filelist{$prefix .'/'. $entry} = \%info;
            $filesource{$prefix .'/'. $entry} = $file;
        }
    }
    $self->{kitfiles} = \%filelist;
    $self->{filesource} = \%filesource;
    return 1;
}

sub Extract{
	my ($self, $destdir) = @_;
	if ($self->isa ('SDB::Install::Package::Installed')){
		die ("Extract () is not allowed in this context.\n");
	}
	# extract files from archive:
	unless (defined $self->SUPER::Extract()){
		return undef;
	}
	# copy files from installation kit and add them:
	unless (defined $self->{kitfiles}){
		$self->FindKitFiles ();
	}
	my $config = {'createdir' => 1};
	if ($^O !~ /mswin/i){
		$config->{uid} = $self->{installation}->getUID ();
		$config->{gid} = $self->{installation}->getGID();
	}
	my $files = $self->{kitfiles};
	my $mode;
	my $path = defined $destdir ? $destdir : $self->getPath ();
	foreach my $file (keys (%$files)){
		my $msg = $self->AddProgressMessage ('copying '.$file);
		my $do_chmod = 0;
		if ($file =~ /\.tgz$/i){
			$mode = 0444;
		}
		else{
			$mode = 0555;
		}
		if ($^O !~ /mswin/i and $files->{$file}->{mode} != $mode){
			$files->{$file}->{mode} = $mode;
			$do_chmod = 1;
		}
		$msg->{submsg} = [$self->GenMsg ('INFO', sprintf ("file info: mode = 0%o, size = %d bytes", $files->{$file}->{mode} & 07777,$files->{$file}->{size}))];
		# try to remove readonly attribute on windows:
		if ($isWin){
			my @stat = stat ($path.'/'.$file);
			if (@stat && ($stat[2] & 0222) == 0){
				chmod ($stat[2] | 0222, $path.'/'.$file);
			}
		}
		unless (defined copy_file ($self->{filesource}->{$file},$path.'/'.$file,$config)){
			$self->AddError ('cannot copy file '.$file ,$config);
			return undef;
		}
		if ($do_chmod){
			if (! chmod ($files->{$file}->{mode}, $path.'/'.$file)){
				$self->AddError ("cannot chmod file $path/$file: $!");
				return undef;
			}
		}
		$self->{data}->{files}->{$file} = $files->{$file};
	}
	return 1;
}

sub Postuninstall{
	# Change the current working directory, because installer uses its
	# runtime directory for this purpose.
	# Otherwise the installer directory will survive the uninstallation
	# on Windows:
	if ($isWin){
		chdir ('C:\\');
	}
	return 1;
}


#This function overrides 'getShortcutDefinitions'
#from 'Package.pm'.
sub getShortcutDefinitions {
    my ($self) = @_;
    my $retval;
        $retval = [];
    return $retval;
}

1;

