use File::Spec;

sub Postinstall() {
    my (
        $self
    ) = @_;
    if ($^O ne 'MSWin32')
    {
        my $path = $self->getPath();
        my $scriptname = File::Spec->catfile( $path, 'hdbclienv.sh' );
        open(FH, "<".$scriptname) || die "Can't open hdbclienv.sh for reading";
        my @contents = <FH>;
        close(FH);
        my @replaced;
        foreach(@contents) {
            $_ =~ s/\@REPLACE_INSTALL_PATH\@/$path/g;
            push(@replaced, $_);
        }
        open(FH, ">".$scriptname) || die "Can't open hdbclienv.sh for writing";
        print FH @replaced;
        close(FH);
    }
    return 1;
}

1;

