use SDB::Install::SysVars;
use SDB::Install::System qw (exec_program);

use strict;

our $listname = 'hdbclient.lst';

sub getExternalFileListName{
    return $listname;
}

sub Postinstall() {
        my (
            $self
        ) = @_;
        my $path = $self->getPath();
        my $exeExt = $isWin ? '.exe' : '';
        my $sqldbcCons = $path.$path_separator.'hdbsqldbc_cons'.$exeExt;
        if(-f $sqldbcCons) {
            $self->AddMessage("Running $sqldbcCons to detect and remove invalid shared memory.");
            my $rc = exec_program($sqldbcCons, ['-w', '256']);
            if(defined $rc) { 
                $self->AddMessage("$sqldbcCons returned $rc.");
            }
        }
        return 1;
}

1;
