package LCM::App::ApplicationContext;

use strict;
use LCM::Installer;
use SDB::Install::Manifest;
use SDB::Install::Globals qw ($gFlavourPlatform);
use File::Spec;

use constant BATCH_MODE => 'Batch';
use constant CLI_MODE   => 'CLI';
use constant GUI_MODE   => 'GUI';
use constant SLP_MODE   => 'SLP';

my $new = sub {
	my $class = shift();
	my $installer = new LCM::Installer();
	my $manifest = new SDB::Install::Manifest(File::Spec->catfile($installer->getRuntimeDir(), 'manifest'));
	return bless({ _manifest => $manifest }, $class);
};

our $instance;

sub getInstance {
	if (!defined $instance){
		$instance = $new->('LCM::App::ApplicationContext');
	}
	return $instance;
}

sub getFlavourProductName {
    my $application = getInstance()->getApplication();
    my $flavour = $application->getFlavour();
    return SDB::Install::Globals::getFlavourProductName($flavour);
}

sub isServerManifestAvailable {
    my $serverManifest = getInstance()->getServerManifest();
    return defined $serverManifest;
}

sub getServerManifest {
	return $_[0]->{_serverManifest};
}

sub setServerManifest {
	return $_[0]->{_serverManifest} = $_[1];
}

sub getApplicationManifest {
	return $_[0]->{_manifest};
}

sub setApplication {
	my ($self, $application) = @_;
	$self->{_application} = $application;
}

sub getApplication {
	my ($self) = @_;
	return $self->{_application};
}

sub setConfiguration {
	my ($self, $configuration) = @_;
	$self->{_configuration} = $configuration;
}

sub getConfiguration {
	my ($self) = @_;
	return $self->{_configuration};
}

sub setExecutor {
	my ($self, $executor) = @_;
	$self->{_executor} = $executor;
}

sub getExecutor {
	my ($self) = @_;
	return $self->{_executor};
}

sub getScenario {
	my ($self) = @_;
	return $self->getConfiguration()->getAction();
}

sub getMode {
	my $self = shift();

	if($self->getApplication()->isa('LCM::Fcgi::App::LCMFcgiApp')) {
		return SLP_MODE;
	}
	if($self->getApplication()->isa('LCM::Gui::App::LCMGuiApp')) {
		return GUI_MODE;
	}
	if($self->getApplication()->isa('LCM::App::BaseApplication')) {
		if($self->getApplication()->isBatchMode()) {
			return BATCH_MODE;
		}
		return CLI_MODE;
	}
	return undef;
}

sub isBatch {
	my ($self) = @_;
	return $self->getMode() eq BATCH_MODE;
}

sub isCLI {
	my ($self) = @_;
	return $self->getMode() eq CLI_MODE;
}

sub isGUI {
	my ($self) = @_;
	return $self->getMode() eq GUI_MODE;
}

sub isSLP {
	my ($self) = @_;
	return $self->getMode() eq SLP_MODE;
}

1;