#!/usr/bin/perl

package LCM::App::HdbLcmConsole;

use strict;
use LCM::Installer;
use SDB::Install::App::Console;
use SDB::Install::System qw (isSidadmin removeEmptyDirsAtExit);
use LCM::Fcgi::App::EnvironmentUtilities;
use SDB::Install::SysVars qw ($isWin);

our @ISA = qw (SDB::Install::App::Console);

sub main {
	my $app = createApp();
	my $rc = $app->start(@_);
    # try to remove directories, which couldn't be deleted due to .nfs* files
    # caused by busy installer objects:
    my $rootDir = $app->{'rootDirToBeDeletedOnExitOfMain'};
    if (!$isWin && defined $rootDir && -d $rootDir){
        removeEmptyDirsAtExit ($rootDir, defined $rc ? $rc : 1);
    }
	return $rc;
}

sub createApp {
	my $installer = new LCM::Installer();
	if ( $installer->isInstalled() ) {
		require LCM::App::HdbLcmConsoleInstalled;

# Explicitly prepare execution environment for sidadm execution cases
		my $sid = $installer->getSid();
		PrepareExecutionEnvironment($sid) if(isSidadmin($sid));

		return new LCM::App::HdbLcmConsoleInstalled();
	} else {
		require LCM::App::HdbLcmExternalConsole;
		return new LCM::App::HdbLcmExternalConsole();
	}
}


1;
