package LCM::App::HdbLcmExternalConsole;

use strict;
use base qw (LCM::App::BaseApplication);

use LCM::Task::GenericStackTask::InstallProcessTask;
use LCM::Task::GenericStackTask::UpdateProcessTask;
use LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask;
use LCM::Task::HelpProcessTask;
use LCM::Task::DumpConfigfileTemplateProcessTask;
use LCM::Configuration::HdbLcmExternalActionConfiguration;
use LCM::ComponentProgressHandler;

sub createExecutor {
	my ( $self, $action ) = @_;

	my $executor = undef;
    if ($self->isHelp()) {
        return LCM::Task::HelpProcessTask->new($self->getInstconfig(), $self);
    } elsif ($self->isDumpTemplate()) {
        return LCM::Task::DumpConfigfileTemplateProcessTask->new($self->getInstconfig(), $self);
    } elsif ('install' eq $action ){
		$executor = new LCM::Task::GenericStackTask::InstallProcessTask( $self->getInstconfig());
	} elsif ('update' eq $action ) {
		$executor = new LCM::Task::GenericStackTask::UpdateProcessTask( $self->getInstconfig());
	} elsif ('extract_components' eq $action) {
		$executor = new LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask($self->getInstconfig());
	} else {
		...
	}
	
	$executor->addListener(new LCM::ComponentProgressHandler());
	return $executor;
}

sub createConfiguration {
	my ( $self, $action ) = @_;
	require  LCM::Configuration::GenericStackConfigurationFactory;
	my $config;
	my $actionConfig = $self->getActionConfiguration();
	if ( 'install' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createInstallConfiguration($self);
		$config->setComponentManager( $actionConfig->getComponentManager() ) if defined $config;
	} elsif ( 'update' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateConfiguration($self);
		$config->setComponentManager( $actionConfig->getComponentManager() ) if defined $config;	
	} elsif ('extract_components' eq $action) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createExtractComponentsConfiguration($self);
	} else {
		...
	}
# Added because of TIPHANA15IT10-2040
# a 'kit' property is needed in the CollectOtherHostInfos
# method in AnyConfig in case of non-resident hdblcm
	if (defined $actionConfig->{kit}) {
		$config->{kit} = $actionConfig->{kit};
	}
	return $config;
}

sub createActionConfiguration {
	my $self                = shift;

	my $actionConfiguration = new LCM::Configuration::HdbLcmExternalActionConfiguration( $self->{options}, $self->{configfile}, $self->{batch_mode} );
	return $actionConfiguration;
}

sub handleReturnCodes {
	my ( $self, $err, $rc ) = @_;
	
	my $action = $self->{action};
	
	if (defined $rc && $rc == 3 && defined $action) {
		#validation error occurred - do not print help
		$rc = undef;
	}

	return $self->SUPER::handleReturnCodes( $err, $rc );
}

1;
