package LCM::Component::Installable::CockpitStack;

use strict;
use base 'LCM::Component::Installable';
use SDB::Install::System qw(copy_file);
use SDB::Install::SysVars qw($isWin);
use LCM::Component qw(COMPONENT_NAME_COCKPIT_STACK);
use SDB::Install::Globals qw ($gDirNameCockpitStack);

sub installComponent {
	my ($self, $instconfig) = @_;

    my $msg = $self->getMsgLst()->addProgressMessage($self->getProgressMsg() . '...');
    my $rc = 1;
    my $manifestPath = File::Spec->catfile($self->{manifestDir}, 'manifest');
    my $instPath = $self->getInstSidPath($instconfig);
    my $config = $self->_createSidAdmFileCfg($instconfig);
    my $targetFile = File::Spec->catfile($instPath, $gDirNameCockpitStack, 'manifest');
    $msg->getSubMsgLst()->addMessage("Copying cockpit stack manifest from '$manifestPath' to '$targetFile'");
	if(!copy_file($manifestPath, $targetFile, $config)) {
		$self->setErrorMessage("Failed to copy file '$manifestPath'");
		$rc = 0;
	}

	my $type = $self->isUpdate() ? "Update" : "Installation";
    my $endMessage = $self->_getEndMessage($rc, $type);
    $msg->endMessage (undef, $endMessage);
	return $rc;
}

sub _getEndMessage {
    my ($self, $returnCode, $type) = @_;
    my $message = "$type of " . $self->getComponentName();
    $message .= (defined $returnCode && ($returnCode == 1)) ? ' finished' : ' failed';
    return $message;
}

sub _createSidAdmFileCfg{
	my($self, $instconfig) = @_;
	my $fileCfg;
	if (!$isWin){
		my $user = new SDB::Install::NewDBUser($instconfig->getValue('SID'));
        $fileCfg->{uid} = $user->uid();
        $fileCfg->{gid} = $user->gid();
        $fileCfg->{createdir} = 1;
	}
	return $fileCfg;
}

sub updateComponent;
*updateComponent =  \&installComponent;

sub preCheckInstallComponent { return 1; }

sub preCheckUpdateComponent { return 1; }

sub getComponentName { return COMPONENT_NAME_COCKPIT_STACK(); }

sub isInternal { return 1; }

sub getInstallerDir{ return undef; }

sub getHdbInstallExecutable{ return undef; }

sub getHdbUpdateExecutable{ return undef; }

sub getSlppLogFileName { return 'cockpit_stack.log'; }

sub getNumberOfExpectedOutputLines{ return 10; }

1;
