package LCM::Component::Installable::HDBServer::HDBServerRoot;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::System qw(makedir);
use SDB::Install::Globals qw($gLogDir $gProductNameEngine);
use SDB::Install::Configuration::NewDB;
use SDB::Install::Configuration::Upgrade;
use SDB::Install::SAPSystem qw (CleanupSAPSystemCache);
use SDB::Install::Saphostagent qw(sapadmUserExists);
use LCM::Configuration::GenericStackAny qw ($ini_section_server);
use LCM::ProcessExecutor;
use LCM::ExecutionWarningsObservable;

use strict;

use base 'LCM::Component::Installable::HDBServer::HDBServerBase';

our $hdbUpdateExecutable = 'hdbupd' . ($isWin ? '.exe' : '');
our $AddSidadmTimeZoneSHAConfiguration = 'HdblcmAddSidadmTimeZone';

sub preCheckInstallComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Checking " . $self->getComponentName() . " for install...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $command = $self->getHdbInstallExecutable();
    my $args = $instconfig->getCmdLineArgsFromInstconfig(new SDB::Install::Configuration::NewDB(),
                                         undef, $ini_section_server, 'hdbinst');
    push @$args, qw(-b --check_only -a), $self->{manifestDir};
    push @$args, '--instlog_dir=' . $gLogDir;
    my $stdinLines = $instconfig->getXmlPasswordStream();
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Checking of ' . $self->getComponentName() . ' for install failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }
    $msg->endMessage (undef, "Checking " . $self->getComponentName() . " for install");
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub preCheckUpdateComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Checking " . $self->getComponentName() . " for update...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $command = $self->getHdbUpdateExecutable();
    my $args = $instconfig->getCmdLineArgsFromInstconfig(new SDB::Install::Configuration::Upgrade(),
                                          undef, $ini_section_server, 'hdbupd');
    push @$args, qw(-b --check_only -a), $self->{manifestDir};
    push @$args, '--instlog_dir=' . $gLogDir;
    my $stdinLines = $instconfig->getXmlPasswordStream();
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Checking of ' . $self->getComponentName() . ' for update failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }
    $msg->endMessage (undef, "Checking " . $self->getComponentName() . " for update");
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

# renamed from 'apply':
sub installComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $cfg = {};

    # create directories for data and log volumes
    foreach my $dir ($instconfig->getValue ('BasePathDataVolumes'),
                     $instconfig->getValue ('BasePathLogVolumes')){
        if (!-e $dir){
            $self->getMsgLst ()->addMessage("Creating directory '$dir'");
            if (!defined makedir ($dir,$cfg)){
                $self->setErrorMessage ("Cannot create directory '$dir'", $cfg);
                $msg->endMessage (undef, 'Install ' . $self->getComponentName());
                $self->setMsgLstContext($saveCntxt);
                return undef;
            }
        }
    }

	my @paramsToSkip = ('AddHosts');
    if ( $isWin ) {
    	my $shaUserExists = sapadmUserExists($instconfig->getValue('HostagentUserName'));
    	if ( !$shaUserExists ) {
    		 push @paramsToSkip, 'HostagentUserName';
    	}	
    }
    
    my $args = $instconfig->getCmdLineArgsFromInstconfig(new SDB::Install::Configuration::NewDB(),
                                         \@paramsToSkip, $ini_section_server, 'hdbinst');
    push @$args, '--instlog_dir=' . $gLogDir;

	my $isAutoAddEnabled = $instconfig->getValue('AutoAddXS2Roles') && !$instconfig->isSkipped('AutoAddXS2Roles');
    if( defined $instconfig->getValue('AddHosts') && !$isAutoAddEnabled) {
    	my @addHosts = split(/\s*,\s*/, $instconfig->getValue('AddHosts'));                              
		my @hosts = grep(!/extended_storage_worker|extended_storage_standby|ets_worker|ets_standby|streaming|rdsync|xs/, @addHosts);
		if ((scalar(@hosts) > 0)) {
			push @$args, $instconfig->getOpt('AddHosts') . '=' . join(',', @hosts);
		}
    }
	
    push @$args, qw(-b -a), $self->{manifestDir};
    my $stdinLines = $instconfig->getXmlPasswordStream();
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }

    my $command = $self->getHdbInstallExecutable();
    my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Installation of ' . $self->getComponentName() . ' failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Install ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    CleanupSAPSystemCache();
    return $rc;
}

sub _appendToFile {
    my ( $self, $filepath, $line ) = @_;
    my $fh;
    if (!open ($fh, '>>' . $filepath)){
        $self->setErrorMessage ("Cannot open file '$filepath' : $!");
        return undef;
    }
    print $fh $line . "\n";
    close $fh;
}

sub updateComponent {
    my ( $self, $instconfig ) = @_;
    my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $cfg = {};
    $self->initProgressHandler ();

	my $exitCode;
	my $rc = 1;
	my $command = $self->getHdbUpdateExecutable();
	my $args = $self->_buildArgs($instconfig);
	push @$args, '-b';
	push @$args, '--instlog_dir=' . $gLogDir;
    my $stdinLines = $instconfig->getXmlPasswordStream();
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    if($instconfig->hasValue('ISCMode')){
        push(@{$args}, sprintf('--isc_mode=%s', $instconfig->getValue('ISCMode')));
    }

	my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
	$exer->setOutputHandler($self->getProgressHandler ());
	$exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment());
	$exitCode = $exer->executeProgram();
	$self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
	$self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

	#check for deploy content error. handle it as warning
    if ((defined $exitCode) && ($exitCode == 2)) {
        $self->getMsgLst()->addWarning("Problems occurred while importing delivery units (content)");
		LCM::ExecutionWarningsObservable->getInstance()->notifyWarning("'$gProductNameEngine' update finished with warning, because of\n" .
															"failed deployment of HANA content (part of '$gProductNameEngine' archive).\n" .
															"To retry the deployment, run hdblcm again and choose to resume the pending\n" .
															"'$gProductNameEngine' update. For next steps, check SAP Note 1795885.");
    } elsif (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Update of ' . $self->getComponentName() . ' failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }
	
	$msg->endMessage (undef, "Updating " . $self->getComponentName());
	$self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getHdbUpdateExecutable{
    my ($self) = @_;
    return File::Spec->catfile($self->getInstallerDir(), $hdbUpdateExecutable);
}

sub  register{
    my ( $self, $instconfig, ) = @_;
    
    my $remoteExecution = $instconfig->{options}->{remote_execution};
    if (defined $remoteExecution && $remoteExecution eq 'saphostagent') {
        return 1; 
    }
    
    my $hdbInstance = $instconfig->{hdbInstance};
    my $binDir = $hdbInstance->get_globalTrexInstallProgamDir();
    my $shellScript = $binDir . $path_separator . 'hdbreg'; 
    
    my $args = [];
    push @$args, "--main", "SDB::Install::App::Console::DBUpgradeHost::main", "--batch";
    my $stdinLines = $instconfig->getXmlPasswordStream(['Password']);
    push @$args, '--instlog_dir=' . $gLogDir;
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    
    my $message = "Registering " . $self->getComponentName();
    $self->getMsgLst()->addProgressMessage( $message . "..." );
    my $executor = new LCM::ProcessExecutor($shellScript, $args, $stdinLines);
    my $rc = $executor->executeProgram(1); 
    
    $self->getMsgLst()->addMessage(undef, $executor->getMsgLst()); # appendMsgLst
    
    # Success exit code is 0
    if ( ! $rc ) {
        $self->getMsgLst()->addMessage( $message . " finished successfully");
    } else {
        $self->getMsgLst()->addError( $message . " finished with error");
    }
    
    return ( ! $rc );
}

1;