package LCM::Component::Installable::LMStructure;

use strict;
use base 'LCM::Component::Installable';
use LCM::Landscape::LandscapeDescription;
use LCM::Component qw(COMPONENT_NAME_LM_STRUCTURE);

sub installComponent {
	my ($self, $instconfig) = @_;
	my $isUpdate = $self->isUpdate();
	my $sid = $instconfig->getSID();
	my $progressMessage = ($isUpdate ? 'Updating ' : 'Creating ') . COMPONENT_NAME_LM_STRUCTURE() . '...';
	my $failedMessage = ($isUpdate ? 'Updating ' : 'Creating ') . COMPONENT_NAME_LM_STRUCTURE() . ' failed';
	my $message = $self->getMsgLst()->addProgressMessage($progressMessage);
	my $landscapeDescription = undef;
	my $errorMessagePrefix = $isUpdate ? 'Update of' : 'Creation of';
	my $errorMessage = sprintf('%s %s failed', $errorMessagePrefix, COMPONENT_NAME_LM_STRUCTURE());

	eval{
		local $SIG{__DIE__} = 'DEFAULT';
		$landscapeDescription = new LCM::Landscape::LandscapeDescription([$message->getSubMsgLst()], $sid);
	};

	if($@ || !defined($landscapeDescription)){
		$self->getErrMsgLst()->addError($errorMessage)->getSubMsgLst()->addError($@);
		$message->endMessage($failedMessage);
		return undef;
	}
	if(!$landscapeDescription->getErrMsgLst()->isEmpty()){
		$self->getErrMsgLst()->addError($errorMessage, $landscapeDescription->getErrMsgLst());
		$message->endMessage($failedMessage);
		return undef;
	}
	if($landscapeDescription->store()){
		$message->endMessage();
		return 1;
	}
	$message->endMessage($failedMessage);
	return undef;
}

sub updateComponent;
*updateComponent =  \&installComponent;

sub preCheckInstallComponent { return 1; }

sub preCheckUpdateComponent { return 1; }

sub getComponentName { return COMPONENT_NAME_LM_STRUCTURE(); }

sub isInternal { return 1; }

sub getInstallerDir{ return undef; }

sub getHdbInstallExecutable{ return undef; }

sub getHdbUpdateExecutable{ return undef; }

sub getSlppLogFileName { return 'lm_structure.log'; }

sub getNumberOfExpectedOutputLines{ return 10; }

1;
