package LCM::Component::Installable::RDSync;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw ($gDirNameRDSync
                              $gLogDir
                              $gProductNameRDSync
                              $gShortProductNameRDSync
                              $gHostRoleRDSync
                              $gTmpDir);
use LCM::ProcessExecutor;
use LCM::Installer;
use LCM::FileUtils;
use File::Basename qw (dirname);
use strict;

use base 'LCM::Component::Installable';

our $installScript = 'rdsyncinst';
our $updateScript = 'rdsyncupd';
if ($isWin){
    $installScript .= '.exe';
    $updateScript .= '.exe';
} else {
    $installScript .= '.sh';
    $updateScript .= '.sh';
}

sub installComponent {
    my ( $self, $instconfig) = @_;
    my $msg = $self->getMsgLst()->addProgressMessage($self->getProgressMsg() . '...');

    my $saveCntxt = $self->setMsgLstContext( [ $msg->getSubMsgLst() ] );

    my $sapSystem = $self->getSAPSystem ( $instconfig, $msg, $saveCntxt);
    if (not defined $sapSystem) {
        return undef;
    }

    my $returnCode = $self->_installRemoteDataSyncComponent($instconfig, $sapSystem);
    my $endMessage = $self->_getEndMessage($returnCode);
    $msg->endMessage (undef, $endMessage);
    $self->setMsgLstContext($saveCntxt);
    return $returnCode;
}


sub _getEndMessage {
	my ($self, $returnCode) = @_;
	my $message = 'Installation of ' . $self->getComponentName();
	$message .= ($returnCode == 1) ? ' finished' : ' failed';
	return $message;
}

sub _installRemoteDataSyncComponent {
	my ($self, $instconfig, $sapSystem) = @_;
	my $exer = $self->createProcessExecutor($instconfig, $sapSystem);

    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $exer->executeProgram();

    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        my $actionErr = $self->isUpdate() ?'Update ' : 'Installation ';
        my $errorMessage = "$actionErr of " . $self->getComponentName() . ' failed';
        $self->setErrorMessage ($errorMessage, ($errMsgLst->isEmpty() ? $exer->getErrMsgLst() : $errMsgLst));
        return undef;
    }
 	return 1;
}

sub getSAPSystem {
    my ( $self, $instconfig, $msg, $saveCntxt) = @_;

    my $systems = $instconfig->CollectSAPSystems (undef, 1);
    my $sid = $instconfig->getValue("SID");
    my $sapSystem = $systems->{$sid};
    if (not defined $sapSystem) {
        $self->setErrorMessage ("No SAP system '$sid' found");
        $msg->endMessage( undef, 'Install ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }
	return $sapSystem;
}

sub _buildArgs {
    my ($self, $instconfig, $inst_dir, $inst_number, $basepath_down, $basepath_up ) = @_;
    my @arguments = ();
    push( @arguments, '-path');
    push( @arguments, $inst_dir);
    push( @arguments, '-sid');
    push( @arguments, $instconfig->getSID ());
    push( @arguments, '-inst');
    push( @arguments, $inst_number);
    if (!$self->isUpdate()){
		push( @arguments, '-filetransfer_down');
		push( @arguments, $basepath_down);
		push( @arguments, '-filetransfer_up');
		push( @arguments, $basepath_up);
    }

    my $hostname   = undef;
    my $instance = $instconfig->getOwnInstance();

    if (defined $instance) {
        $hostname   = $instance->get_host();
    }

    if (defined $hostname) {
        push( @arguments, '-hdbhost');
        push( @arguments, $hostname);
    }

    my $user = $instconfig->getValue ('SystemUser');
    if (defined $user ) {
        push( @arguments, '-hdbuser');
        push( @arguments, $user);
    }

    push( @arguments, '-log_dir');
    push( @arguments, $gLogDir);
    push @arguments, @{$self->SUPER::_buildArgs($instconfig)};
    return \@arguments;
}

sub createProcessExecutor{
    my ($self, $instconfig, $sapSystem) = @_;

    my $user = $sapSystem->getUser();
    my $inst_number = $sapSystem->getNewDBInstanceNr();
    my $inst_dir = $sapSystem->get_globalSidDir();
    my $basepath_down = $instconfig->getValue ('BasepathFileDownloadRDSync');
    my $basepath_up = $instconfig->getValue ('BasepathFileUploadRDSync');
    my $uid = $user->uid();
    my $gid = $user->gid();

    my $instance = $sapSystem->getNewDBInstances ()->[0];

    my $stdinPassword = [ $instconfig->getValue ('SQLSysPasswd') ];

    my $command = $self->getRDSInstallerDir ();
    my $args = $self->_buildArgs($instconfig, $inst_dir, $inst_number, $basepath_down, $basepath_up);
    if ($self->isSidAdmUserExecution()) {
    	return new LCM::ProcessExecutor($command, $args, $stdinPassword);
    }
    my $exer = new LCM::ProcessExecutor($command, $args, $stdinPassword, dirname ($command), undef, $uid, $gid);
    my %env = %ENV;
    $exer->setProcessEnvironment ($instance->_getHDBEnv (\%env));
    return $exer;
}

sub preCheckInstallComponent {
    return 1;
}

sub getRDSInstallerDir {
    my ($self) = @_;
    my $script = $self->isUpdate() ? $updateScript : $installScript;
    return File::Spec->catfile($self->getInstallerDir(), $script);
}

sub getNumberOfExpectedOutputLines{
    return 75;
}

sub getDefaultSelection{
    my ($self, $stackUpdate) = @_;
    return ($stackUpdate) ? $self->SUPER::getDefaultSelection ($stackUpdate) : 0;
}

sub getComponentName {
	return $gProductNameRDSync;
}

sub getSlppLogFileName {
	return 'remote_data_sync.log'
}

sub requireSystemRestart {
    return 0;
}

sub parseLogFileLocation {
    my ($self, $outputLines) = @_;
    if (!defined $outputLines){
        return undef;
    }
    my $log_location;
    my $pattern = "Log file written to [\']*([^\']*)[\']*";
    foreach my $line (reverse @$outputLines){
        if (substr ($line, -1) eq '.') {
           chop $line;
        }
        ( $log_location ) = $line =~ /$pattern/i;

        if (defined $log_location) {
            return $log_location;
        }
    }
}

sub updateComponent;
*updateComponent =  \&installComponent;

sub getHostRoles {
    return [$gHostRoleRDSync];
}

sub requiresSqlSysPasswd{
    return 1;
}

1;
