package LCM::Component::Installable::ResidentInstaller::ResidentInstallerBase;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Persistence::XMLGenerator;
use SDB::Install::Globals qw($gDirNameResidentInstaller);
use LCM::Component qw (COMPONENT_NAME_INSTALLER OFFLINE_PHASE);
use LCM::Manifests::SAPSignature;

use strict;

use base qw(LCM::Component::Installable);

my $PENDING_FILE_NAME = 'pending_hdblcm.xml';

sub new {
    my $self = shift->SUPER::new (@_);
    $self->selectComponent();
    return $self;
}

sub preCheckInstallComponent {
    return 1;
}

sub preCheckUpdateComponent {
    return 1;
}

sub getNumberOfExpectedOutputLines{
    return 15;
}

sub getDefaultSelection{
    my ($self, $stackUpdate) = @_;

	if (!$stackUpdate) {
		return 1;
	}

	my $installedComponent = $self->getInstalledComponent();
	if (!$installedComponent) {
		return 1;
	}

	my $newVersion = new SDB::Install::Version(split('\.', $self->getVersion()));
	my $installedVersion = new SDB::Install::Version(split('\.', $installedComponent->getVersion()));
	if ($installedVersion->isNewerThan($newVersion)) {
		return 0;
	} else {
		return 1;
	}
}

sub getComponentName {
    return COMPONENT_NAME_INSTALLER;
}

sub isInternal{
	return 1;
}

sub getUpdateHostProgressMessage {
    my $componentName = $_[0]->getComponentName();
    return "Configuring $componentName...";
}

sub getSlppLogFileName {
	return 'hdblcm.log'
}

sub getDefaultPhase {
	return OFFLINE_PHASE;
}

sub executeInstall {
    ...
}

sub executeUpdate {
    ...
}

sub installComponent {
    my ($self, $instconfig) = @_;
    my $rc = $self->_createPendingFile($instconfig);
    if (!$rc) {
        $self->getErrMsgLst()->addError("Could not create pending hdblcm file.");
        return undef;
    }
    $rc = $self->executeInstall($instconfig);
    $self->_deletePendingFile($instconfig) if ($rc);
    return $rc;
}

sub updateComponent {
    my ($self, $instconfig) = @_;
    my $rc = $self->_createPendingFile($instconfig);
    if (!$rc) {
        $self->getErrMsgLst()->addError("Could not create pending hdblcm file.");
        return undef;
    }
    $rc = $self->executeUpdate($instconfig);
    $self->_deletePendingFile($instconfig) if ($rc);
    return $rc;
}

sub _createPendingFile {
    my ($self, $instconfig) = @_;
    my $xmlString = $self->_createPendingXMLString($instconfig);
    if (!$xmlString) {
        return undef;
    }

    my $filename = $self->_getPendingFilename($instconfig);
    if (!open (FH, '>' . $filename)){
        $self->getErrMsgLst()->addError("Cannot create file '$filename': $!");
        return undef;
    }

    print FH $xmlString;

    if (!close (FH)) {
        $self->getErrMsgLst()->addError("Cannot close created file '$filename': $!");
        return undef;
    }

    return 1;
}

sub _createPendingXMLString {
    my ($self, $instconfig) = @_;
    my $generator = SDB::Install::Persistence::XMLGenerator->new();

    my $installedComponent = $self->getInstalledComponent();
    if (defined $installedComponent) {
        $generator->setSourceVersionString($installedComponent->getVersion());
    }
    $generator->setTargetVersionString($self->getVersion());
    my $componentName = $self->getComponentName();
    $generator->setComponentNameString($self->getComponentName());
    if ($instconfig->isUpdate()) {
        $generator->setActionString('update');
        $generator->setCurrentStepString("Updating $componentName");
    } else {
        $generator->setActionString('install');
        $generator->setCurrentStepString("Installing $componentName");
    }
    $generator->setNextPhaseString('offline');

    my $xmlString = $generator->generatePersistenceXMLString();
    if (!$xmlString) {
        $self->getErrMsgLst()->addError($generator->getErrorString());
        return undef;
    }
    return $xmlString;
}

sub _deletePendingFile {
    my ($self, $instconfig) = @_;

    my $filename = $self->_getPendingFilename($instconfig);
    unlink $filename;
}

sub _getPendingFilename {
    my ($self, $instconfig) = @_;

    my $instPath = $self->getInstSidPath($instconfig);
    return File::Spec->catfile($instPath, $PENDING_FILE_NAME);

}

sub shouldVerifyFiles {
    my $self = shift;
    my @serverComponentMatch = grep { $_->isServer() } @{$self->getComponentManager()->getSelectedComponents()};
    if( scalar(@serverComponentMatch) > 0 ){
        my $serverSignature = $serverComponentMatch[0]->getSignature();
        if( defined $self->getSignature() && defined $serverSignature && $self->getSignature()->getSignatureFilePath() eq $serverSignature->getSignatureFilePath()){
            return 0;
        }
    }
    return 1;
}

sub _getInstallationPath {
    my ($self, $instconfig) = @_;
    my $instSidDir = $self->getInstSidPath($instconfig);
    return defined($instSidDir) ? File::Spec->catfile($instSidDir, $gDirNameResidentInstaller) : undef;
}

1;
