package LCM::Component::Installable::ResidentInstaller::ResidentInstallerSidAdm;

use LCM::Component;
use SDB::Install::System qw (isAdmin);
use SDB::Install::Globals qw(determineSignedManifestContainingDirectory);

use strict;

use base qw(LCM::Component::Installable::ResidentInstaller::ResidentInstallerBase);

sub executeInstall {
	$_[0]->setErrorMessage ("Install resident hdblcm component with sidadm user is not implemented");
    return 1;
}

sub isUpdate{
	return 1;
}

sub executeUpdate {
	my ($self, $instconfig) = @_;

    $self->initProgressHandler ();
    my $msg;
    if(! isAdmin()){
        $msg = $self->getMsgLst()->addMessage("Updating " . $self->getComponentName() . "...");
    } else {
        $msg = $self->getMsgLst()->addProgressMessage("Updating " . $self->getComponentName() . "...");
	}
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
	my $operation = 'update_resident_hdblcm_v6';
	my $sid = $instconfig->getSID();
    my $verifySignature = $instconfig->getValue('VerifySignature') ? 'on' : 'off';
    my $ignore = $instconfig->getIgnore('verify_signature') ? 'verify_signature,check_pending_upgrade' : 'check_pending_upgrade';
	my $manifestDir = determineSignedManifestContainingDirectory($self->getInstallerDir());
	my $optionMap = {'HDBLCM_CMP_PATH'     => $self->getInstallerDir(),
					 'MANIFEST_PATH'       => $manifestDir,
                     'VERIFY_SIGNATURE'    => $verifySignature,
                     'IGNORE'              => $ignore,
					 'SID'                 => $sid,
					};
	my $user = new SDB::Install::NewDBUser($sid);
	my $uid = $user->uid();
	my $gid = $user->gid();

	if (defined $uid && defined $gid) {
		$optionMap->{'INSTLOG_UID'} = $uid;
		$optionMap->{'INSTLOG_GID'} = $gid;
	}

	my $passwordKeys = ['Password'];


	my $rc = $self->installThroughSHAOperation($instconfig, $operation, $optionMap, $passwordKeys, 1);

	$self->setMsgLstContext($saveCntxt);

    if (not defined $rc) {
    	return undef;
    }

    $msg->endMessage (undef, 'Update ' . $self->getComponentName());
    return $rc;
}

sub updateSHAOptionsMap {
	my ($self, $optionMap, $newInstallationKitPath) = @_;
	$optionMap->{HDBLCM_CMP_PATH} = $newInstallationKitPath;
	$optionMap->{MANIFEST_PATH} = $newInstallationKitPath;
}

sub getFilelistFileName {
	return 'filelist.resident';
}

sub getCopyInstallerOperation {
	return 'HdbCopyHdblcmInstaller_v4';
}

sub getDeleteCopiedInstallerOperation {
	return 'HdbRemoveCopiedHdblcmInstaller_v1';
}

sub getCopiedInstallerDirPrefix {
	return 'hdblcm_installer_kit_';
}

1;
