package LCM::Component::Installed::ES;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw($gHostRoleEsStandby
                             $gHostRoleEsWorker
                             $gProductNameEs
                             $gLogDir);
use SDB::Install::System qw (isAdmin);
use LCM::ProcessExecutor;
use LCM::Installer;
use strict;

use parent 'LCM::Component::Installed';

our $esUninstallExecutable = 'esuninst' . ($isWin ? '.exe' : '.sh');

sub preCheckUninstallComponent {
    my ($self, $instconfig) = @_;
	return $self->checkComponentHostsExist($instconfig);
}

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $sapSystem = $instconfig->getSAPSystem(1); # no cache
    if (!defined($sapSystem)) {
        $self->setErrorMessage(sprintf("No SAP system '%s' found", $instconfig->getValue("SID")));
        $msg->endMessage( undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }

    # uninstall
    $self->cleanComponentDaemonIniEntries($instconfig);
    my $exer = $self->_createProcessExecutor($instconfig, $sapSystem);

    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $exer->executeProgram();

    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getComponentName {
	return $gProductNameEs;
}

sub getNumberOfExpectedOutputLines{
    return 15;
}

sub getHostRoles {
    return [$gHostRoleEsWorker, $gHostRoleEsStandby];
}

sub getSlppLogFileName {
    return 'extended_storage.log'
}

sub _createProcessExecutor{
    my ($self, $instconfig, $sapSystem) = @_;
    my $command = join($path_separator, $sapSystem->get_globalSidDir(), 'es', 'hdblcm', $esUninstallExecutable);
    my $arguments = $self->_buildUninstallArguments($instconfig);
    my $stdinPassword = $self->_buildUninstallInputStrings($instconfig);
    my ($uid, $gid) = (undef, undef);

    if (isAdmin()){
        my $user = $sapSystem->getUser();
        ($uid, $gid) = ($user->uid(), $user->gid());
    }

    return new LCM::ProcessExecutor($command, $arguments, $stdinPassword, undef, undef, $uid, $gid);
}

sub _buildUninstallArguments {
    my ($self, $instconfig) = @_;
    my @arguments = ();

    my $user = $instconfig->getValue ('SystemUser');
    if (defined($user)) {
        push( @arguments, ('-hdbuser', $user));
    }

    my $systemComponentManager = $instconfig->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();
    if (!$isForced) {
        push( @arguments, '-stdIn');
    }

    push(@arguments, ('-log_dir', $gLogDir));
    return \@arguments;
}

sub _buildUninstallInputStrings {
    my ($self, $instconfig) = @_;
    my $systemComponentManager = $instconfig->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();

    return $isForced ? undef : [ $instconfig->getValue ('SQLSysPasswd') ];
}

1;