package LCM::Component::Installed::HDBClient;

use SDB::Install::SysVars qw($isWin $path_separator);
use LCM::HDBComponentsConfigurator qw($action_unregister);
use SDB::Install::Globals qw($gProductNameClient);
use LCM::ProcessExecutor;
use LCM::Installer;
use LCM::HDBComponentsConfigurator qw($action_register $action_unregister);
use LCM::Component::Registrable qw($RETURN_CODE_SUCCESS $RETURN_CODE_ERROR);
use SDB::Install::System qw(isAdmin);
use SDB::Install::DirectoryWalker;

use Cwd qw (realpath);
use strict;

use parent 'LCM::Component::Installed','LCM::Component::Registrable';

our $hdbUninstallExecutable = 'hdbuninst' . ($isWin ? '.exe' : '');

sub uninstallComponent{
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    if(! isAdmin()) { # Ensure write permissions for all directories in the installation
        $self->_enableFullPermissionsForInstallationDirectories();
    }

    # uninstall
    my $command = $self->getHdbUninstallExecutable();
    my $args = [];
    my $manifestDirectory = $self->getPath();
    push @$args, qw(-b), '--path='. realpath($manifestDirectory);
    my $exer = new LCM::ProcessExecutor($command, $args);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    } else {
        $self->removeComponentDirectory($manifestDirectory);
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getComponentName {
	return $gProductNameClient;
}

sub getHdbUninstallExecutable{
    my ($self) = @_;
    if (!defined $self->{hdbUninstallExecutable}){
        $self->{hdbUninstallExecutable} = join($path_separator, $self->getHdbInstallerDir(), 'install', $hdbUninstallExecutable);
    }
    return $self->{hdbUninstallExecutable};
}

sub getSlppLogFileName {
    return 'client.log'
}

sub register {
    my($self,$logger,$instconfig,$sharedDir,$sid) = @_;
    my $componentName = $self->getComponentName();
    $logger = defined($logger) ? $logger : $self;
    my $rc = $self->configureHdbComponents ($logger, ['hdbclient'], $sharedDir, $sid, $action_register);

    return defined($rc) ? $RETURN_CODE_SUCCESS : $RETURN_CODE_ERROR;
}

sub unregister {
    my($self,$logger,$instconfig,$sharedDir,$sid) = @_;
    my $componentName = $self->getComponentName();
    $logger = defined($logger) ? $logger : $self;
    my $rc = $self->configureHdbComponents($logger, ['hdbclient'], $sharedDir, $sid, $action_unregister);

    return defined($rc) ? $RETURN_CODE_SUCCESS : $RETURN_CODE_ERROR;
}

sub _enableFullPermissionsForInstallationDirectories {
	my ($self) = @_;
	my $dirWalker = SDB::Install::DirectoryWalker->new(
		undef, undef, undef,
		sub{
			return -d File::Spec->catfile($_[3], $_[4]) ? 0 : 1;
		},
		undef, undef,
		sub{
			my $fullFilePath = File::Spec->catfile($_[3], $_[4]);
			my $currentMode = (stat($fullFilePath))[2] & 07777;
			chmod($currentMode | 0700, $fullFilePath);
			return 1;
		},
		undef, undef, 0, 1, 1
	);
	$dirWalker->findAndProcess($self->getPath());
}

1;
