package LCM::Component::Installed::HDBServerPlugin::HDBServerPluginBase;

use strict;
use parent 'LCM::Component::Installed';
use SDB::Install::Globals qw ($gKeynameEngine);

sub uninstallComponent{
    ...
}

sub getHdbUninstallExecutable{
    my ($self) = @_;
    if (!defined $self->{hdbUninstallExecutable}){
        my $componentMgr = $self->getComponentManager();
        my $server = $componentMgr->getComponentByKeyName($gKeynameEngine);

        return undef if (!defined $server);

        $self->{hdbUninstallExecutable} = $server->getHdbUninstallExecutable();
    }
    return $self->{hdbUninstallExecutable};
}

sub requireSystemRestart {
    return 0;
}

sub getSlppLogFileName {
	my ($self) = @_;
	return sprintf('%s.log', $self->getManifest()->getComponentKey());
}

1;
