package LCM::Component::Installed::HDBServerPlugin::HDBServerPluginRoot;

use strict;
use LCM::ProcessExecutor;
use parent 'LCM::Component::Installed::HDBServerPlugin::HDBServerPluginBase';

sub uninstallComponent{
    my ($self, $configuration) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $command = $self->getHdbUninstallExecutable();
    if (!defined $command) {
        my $errorMessage = 'Uninstallation of ' . $self->getComponentName() . ' failed: could not find server uninstallation program';
        my $dummyExitCode = 1; # 1 = Failure
        $self->_handleUninstallationExitCode($dummyExitCode, $configuration, undef, $errorMessage);
        $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }
    my $args = [ '-b', sprintf('--path=%s', $self->getPath()) ];
    my $exer = new LCM::ProcessExecutor($command, $args);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setMsgLstContext($self->getMsgLstContext());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $configuration, $errMsgLst);
        $rc = undef;
    } else {
        $self->removeComponentDirectory($self->getPath());
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

1;
