package LCM::Component::Installed::HDBServerPlugin::HDBServerPluginSidAdm;

use strict;
use parent 'LCM::Component::Installed::HDBServerPlugin::HDBServerPluginBase';

my $UNINSTALL_OPERATION = 'HdbUninstallServerPlugin';

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;
    my $optionsMap = $self->_buildOptionsMap($instconfig);
    my $exitCode = $self->_executeThroughSHAOperation($instconfig, $UNINSTALL_OPERATION, $optionsMap, undef, 1, 'Uninstallation');

    return $exitCode if (! defined($exitCode) || $exitCode != 0);

    my $manifestDirectory = $self->getPath();
    $self->removeComponentDirectory($manifestDirectory);
    return $exitCode;
}

sub _buildOptionsMap {
    my ($self, $instconfig) = @_;

    return {
        SID => $instconfig->getSID(),
        PATH => $self->getPath(),
    };
}

1;