package LCM::Component::Installed::LMStructure;

use strict;
use parent 'LCM::Component::Installed';
use LCM::Landscape::LandscapeDescription;
use LCM::Component qw(COMPONENT_NAME_LM_STRUCTURE);

sub uninstallComponent{
	my ($self, $instconfig) = @_;
	my $componentManager = $instconfig->{componentManager};
	my $systemComponentManager = $componentManager->getSystemComponentManager();
	my $isUninstallingSystem = $systemComponentManager->isHDBServerComponentSelected();

	return 1 if($isUninstallingSystem);

	my $sid = $instconfig->getSID();
	my $progressMessage = sprintf('Updating %s...', COMPONENT_NAME_LM_STRUCTURE());
	my $failedMessage = sprintf('Updating %s failed', COMPONENT_NAME_LM_STRUCTURE());
	my $message = $self->getMsgLst()->addProgressMessage($progressMessage);
	my $landscapeDescription = new LCM::Landscape::LandscapeDescription([$message->getSubMsgLst()], $sid);

	if(!$landscapeDescription->getErrMsgLst()->isEmpty()){
		my $errorMessage = sprintf('Update of %s failed.', COMPONENT_NAME_LM_STRUCTURE());
		$self->getErrMsgLst()->addError($errorMessage, $landscapeDescription->getErrMsgLst());
		$message->endMessage($failedMessage);
		return undef;
	}
	if($landscapeDescription->store()){
		$message->endMessage();
		return 1;
	}
	$message->endMessage($failedMessage);
	return undef;
}

sub getComponentName { return COMPONENT_NAME_LM_STRUCTURE(); }

sub isInternal { return 1; }

sub getInstallActionString { return "Updating"; }

sub getSlppLogFileName { return 'lm_structure.log'; }

1;
