package LCM::Component::Installed::LSS;

use strict;
use SDB::Install::SysVars qw( $isWin );
use SDB::Install::Globals qw( $gProductNameLSS );
use SDB::Install::System qw( readLink );
use File::Basename qw( dirname );
use LCM::ProcessExecutor;

use base 'LCM::Component::Installed';

our $uninstallScript = 'hdbuninst';

if ($isWin){
    $uninstallScript .= 'exe';
}

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $sapSystem = $instconfig->getSAPSystem(1);
    if ( !defined($sapSystem) ) {
        $self->setErrorMessage(sprintf("No SAP system '%s' found", $instconfig->getValue("SID")));
        $msg->endMessage( undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }

    my $executor = $self->_createProcessExecutor($instconfig, $sapSystem);
    if ( !defined($executor) ){
        return undef;
    }
    $self->initProgressHandler ();
    $executor->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $executor->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $executor->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($executor->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($executor->getOutputLines());
        $errMsgLst = $executor->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    $instconfig->getOwnInstance()->setLSSInstancesInIniFile(0);
    return $rc;
}

sub _createProcessExecutor{
    my ($self, $instconfig, $sapSystem) = @_;

    my $lssLink = File::Spec->catfile($sapSystem->getUsrSapSid(), 'lss' , 'exe');
    if( !-l $lssLink ){
        return undef;
    }
    my $path = readLink ( $lssLink );
    my $lssInstallationPath = dirname($path);
    my $command = File::Spec->catfile($lssInstallationPath, 'install', $uninstallScript);
    my $arguments = $self->_buildUninstallArguments();
    return new LCM::ProcessExecutor($command, $arguments);
}

sub _buildUninstallArguments {
    return [ '--batch' ];
}

sub getComponentName {
    return $gProductNameLSS;
}

sub getNumberOfExpectedOutputLines{
    return 5;
}

1;
