package LCM::Component::Installed::RDSync;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw($gHostRoleRDSync
                             $gLogDir
                             $gProductNameRDSync
                             $gDirNameRDSync
                             $gTmpDir);
use SDB::Install::System qw (isAdmin);
use LCM::ProcessExecutor;
use LCM::Installer;
use strict;

use base 'LCM::Component::Installed';

our $rdsUninstallExecutable = 'rdsyncuninst';
if ($isWin){
    $rdsUninstallExecutable .= '.exe';
} else {
    $rdsUninstallExecutable .= '.sh';
}

sub preCheckUninstallComponent {
    my ($self, $instconfig) = @_;
    return $self->checkComponentHostsExist($instconfig);
}

sub getRDSyncHanaLcmDir{
    my ($self) = @_;
    if (!defined $self->{_rdsyncHanaLcmDir}){
        $self->{_rdsyncHanaLcmDir} =
        join ($path_separator, $self->getInstallationPath (), 'hdblcm');
    }
    return $self->{_rdsyncHanaLcmDir};
}

sub uninstallComponent{
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);


    my $sapSystem = $instconfig->getSAPSystem(1); # no cache
    if (!defined($sapSystem)) {
        $self->setErrorMessage(sprintf("No SAP system '%s' found", $instconfig->getValue("SID")));
        $msg->endMessage( undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }

    # uninstall
    $self->cleanComponentDaemonIniEntries($instconfig);
    my $exer = $self->_createProcessExecutor($instconfig, $sapSystem);

    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $exer->executeProgram();

    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getComponentName {
	return $gProductNameRDSync;
}

sub getNumberOfExpectedOutputLines{
    return 15;
}

sub getHostRoles {
    return [$gHostRoleRDSync];
}

sub _createProcessExecutor{
    my ($self, $instconfig, $sapSystem) = @_;
    my $command = join($path_separator, $sapSystem->get_globalSidDir(), $gDirNameRDSync, "hdblcm", $rdsUninstallExecutable);
    my $arguments = $self->_buildUninstallArguments($instconfig, $sapSystem);
    my $stdinPassword = $self->_buildUninstallInputStrings($instconfig);
    my ($uid, $gid) = (undef, undef);

    if (isAdmin()){
        my $user = $sapSystem->getUser();
        ($uid, $gid) = ($user->uid(), $user->gid());
    }

    return new LCM::ProcessExecutor($command, $arguments, $stdinPassword, undef, undef, $uid, $gid);
}

sub _buildUninstallArguments {
    my ($self, $instconfig, $sapSystem) = @_;
    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();
    my $dbUsername = $instconfig->getValue ('SystemUser');
    my @arguments = ();

    push( @arguments, ('-sid', $instconfig->getValue('SID')));
    push( @arguments, ('-inst', $instconfig->getOwnInstance()->get_nr()));
    push( @arguments, ('-path', $sapSystem->get_globalSidDir()));
    push( @arguments, ('-log_dir', $gLogDir));
    push(@arguments, ($isForced ? '--force': '-stdIn')); # If force is applied, password input is not needed

    if (defined($dbUsername)) {
        push(@arguments, ('-hdbuser', $dbUsername));
    }

    return \@arguments;
}

sub _buildUninstallInputStrings {
    my ($self, $instconfig) = @_;
    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();

    return $isForced ? undef : [ $instconfig->getValue ('SQLSysPasswd') ];
}

sub getSlppLogFileName {
	return 'remote_data_sync.log'
}

1;
