package LCM::Component::Installed::Streaming;

use SDB::Install::SysVars qw($isWin $path_separator);
use LCM::ProcessExecutor;
use SDB::Install::SAPSystem;
use SDB::Install::SysVars;
use SDB::Install::System qw (isAdmin);
use SDB::Install::Globals qw ($gHostRoleStreaming
                              $gProductNameStreaming
                              $gShortProductNameStreaming);
use strict;

use base 'LCM::Component::Installed';

our $isRunningScript = 'strcheckrunning.sh';
our $stopClusterScript = 'strstopcluster.sh';
our $uninstallScript = 'struninst.sh';

sub preCheckUninstallComponent {
    my ($self, $instconfig) = @_;
	return $self->checkComponentHostsExist($instconfig);
}

sub getComponentName {
	return $gProductNameStreaming;
}

sub getStreamingHanaLcmDir{
    my ($self) = @_;
    if (!defined $self->{_streamingHanaLcmDir}){
        $self->{_streamingHanaLcmDir} =
        join ($path_separator, $self->getInstallationPath (), 'hdblcm');
    }
    return $self->{_streamingHanaLcmDir};
}

sub isRunning{
    my ($self) = @_;
    my $cmd = $self->getStreamingHanaLcmDir () . $path_separator . $isRunningScript;
    my $msg = $self->getMsgLst ()->addMessage ("Checking whether $gProductNameStreaming is running");
    my $exer = new LCM::ProcessExecutor ($cmd,[$self->getInstallationPath ()]);
    $exer->setMsgLstContext ([$msg->getSubMsgLst ()]);
    my $rc = $exer->executeProgram ();
    if (!defined $rc){
        $self->setErrorMessage ("Cannot check whether $gProductNameStreaming is running", $exer->getErrMsgLst ());
        return undef;
    }
    elsif ($rc == 2){
        $self->setErrorMessage ("Cannot check whether $gProductNameStreaming is running", $exer->getMsgLst ());
        return undef;
    }
    return $rc;
}

sub uninstallComponent{
    my ($self, $instconfig) = @_;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $executor = $self->_createProcessExecutor($instconfig);

    $self->cleanComponentDaemonIniEntries($instconfig);

    $self->initProgressHandler ();
    $executor->setMsgLstContext ([$msg->getSubMsgLst()]);
    $executor->setOutputHandler($self->getProgressHandler ());

    my $exitCode;
    {
        #
        # due to a bug in InstallAnywhere $DISPLAY has to be unset
        #
        local %ENV = %ENV;
        delete $ENV{DISPLAY};
        $exitCode = $executor->executeProgram();
    }

    if (!defined($exitCode) || $exitCode){
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $executor->getErrMsgLst());
        $msg->endMessage(undef, sprintf('Uninstalling %s', $self->getComponentName()));
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }

    $msg->endMessage (undef, sprintf('Uninstall %s', $self->getComponentName()));
    $self->setMsgLstContext($saveCntxt);
    return 1;

}

sub getHostRoles {
    return [$gHostRoleStreaming];
}

sub _createProcessExecutor {
    my ($self, $instconfig) = @_;
    my $command = $self->getStreamingHanaLcmDir() . $path_separator . $uninstallScript;
    my $uninstallationArgs = $self->_buildUninstallArguments($instconfig);
    my $passwordInputString = $self->_buildUninstallInputStrings($instconfig);
    my ($uid, $gid) = (undef, undef);

    if (isAdmin()){
        my $sapSystem = $instconfig->getSAPSystem(1); # no cache
        my $user = $sapSystem->getUser();
        ($uid, $gid) = ($user->uid(), $user->gid());
    }

    return new LCM::ProcessExecutor($command, $uninstallationArgs, $passwordInputString, undef, undef, $uid, $gid);
}

sub _buildUninstallArguments {
    my ($self, $instconfig) = @_;
    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();
    my $dbUsername = $instconfig->getValue ('SystemUser');
    my $shouldPassDbUser = defined($dbUsername) && ($dbUsername ne "SYSTEM");

    return [ '--force' ] if($isForced);
    return [ '-hdbuser', $dbUsername ] if($shouldPassDbUser);
    return [];
}

sub _buildUninstallInputStrings {
    my ($self, $instconfig) = @_;
    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();

    return $isForced ? undef : [ $instconfig->getValue ('SQLSysPasswd') ];
}

sub getSlppLogFileName {
	return 'streaming.log'
}

1;
