package LCM::Component::Installed::XS2;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw($gProductNameXS2 $gHostRoleXS2Worker $gHostRoleXS2Standby $gLogDir $gProductNameEngine);
use SDB::Install::System qw (isAdmin);
use LCM::ProcessExecutor;
use LCM::Installer;
use strict;

use base 'LCM::Component::Installed';

our $xsUninstallExecutable = 'hdbuninst';
if ($isWin){
    $xsUninstallExecutable .= '.exe';
}

sub getComponentName {
	return $gProductNameXS2;
}

sub getHostRoles {
    return [$gHostRoleXS2Worker, $gHostRoleXS2Standby];
}

sub preCheckUninstallComponent {
    my ($self, $instconfig) = @_;
    return $self->checkComponentHostsExist($instconfig) ;
}

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    if($systemComponentManager->isHDBServerComponentSelected()){
        my $message = sprintf('Uninstallation of %s will be performed during uninstall of %s. Uninstall skipped...', $self->getComponentName(), $gProductNameEngine);
        $self->getMsgLst()->AddMessage($message);
        $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return $rc;
    }

    my $sapSystem = $instconfig->getSAPSystem(1); # no cache
    if (!defined($sapSystem)) {
        $self->setErrorMessage(sprintf("No SAP system '%s' found", $instconfig->getValue("SID")));
        $msg->endMessage( undef, 'Uninstall ' . $self->getComponentName());
        $self->setMsgLstContext($saveCntxt);
        return undef;
    }
    
    # uninstall
    $self->cleanComponentDaemonIniEntries($instconfig);
    my $exer = $self->_createProcessExecutor($instconfig, $sapSystem);

    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $exer->executeProgram();
    
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }
    if($rc){
    	$rc &= $self->_deleteXSSpaceIsolationUserData($instconfig, $sapSystem);
    }
    if( $rc){
    	my $xs_dir = File::Spec->catdir(($sapSystem->get_globalSidDir(), 'xs'));
        $self->getMsgLst ()->addProgressMessage ("Removing file tree " .$xs_dir . " and app working directory...");
        $rc &= $self->deleteXSPostUninstallData($instconfig, $sapSystem);
    }
    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub _deleteXSSpaceIsolationUserData {
    my ($self, $instconfig, $sapSystem) = @_;
    my $keysForRemoval = ['xs_space_user_sap', 'xs_space_user_sap_id', 'xs_space_user_prod', 'xs_space_user_prod_id'];
    my $systemComponentManager = $instconfig->getSystemComponentManager();
    my $isServerSelected = $systemComponentManager->isHDBServerComponentSelected();

    return 1 if($isServerSelected); # Delete information from user config only when DB is not selected

    $self->getMsgLst()->addMessage('Removing XS Advanced space OS users from user config...');
    if(!$sapSystem->saveConfig(undef, $keysForRemoval)){
        $self->getErrMsgLst()->addError('Removing XS Advanced space OS users from user config failed');
        return undef;
    }
    return 1;
}

sub _createProcessExecutor{
    my ($self, $instconfig, $sapSystem) = @_;
    my $arguments = $self->_buildUninstallArguments($instconfig);
    my $stdinLines = $self->_buildUninstallInputStrings($instconfig);
    my $command = join($path_separator, $sapSystem->get_globalSidDir(), 'xs', 'install', $xsUninstallExecutable);
    my ($uid, $gid) = (undef, undef);

    if (isAdmin()){
        my $user = $sapSystem->getUser();
        ($uid, $gid) = ($user->uid(), $user->gid());
    }

    return new LCM::ProcessExecutor($command, $arguments, $stdinLines, undef, undef, $uid, $gid);
}

sub getSlppLogFileName {
    return 'xs_advanced_runtime.log'
}

sub _buildUninstallArguments {
    my ($self, $instconfig, $sapSystem) = @_;
    my $systemComponentManager = $instconfig->{componentManager}->getSystemComponentManager();
    my $isForced = $systemComponentManager->isHDBServerComponentSelected();
    my @arguments = ();

    my $systemUser = $instconfig->getValue('SystemUser') || 'SYSTEM';
    push( @arguments, "--system_db_user=". $systemUser) if ($systemUser ne 'SYSTEM');
    push  @arguments, '--read_password_from_stdin';
    push( @arguments, ('--instlog_dir', $gLogDir));
    push( @arguments, ('-b'));
    push( @arguments, ($isForced ? '--force' : ()));

    return \@arguments;
}

sub _buildUninstallInputStrings {
    my ($self, $instconfig) = @_;
    my $dbPassword = $instconfig->isSkipped('SQLTenantUserPassword') ?
        $instconfig->getValue ('SQLSysPasswd') :
        $instconfig->getValue('SQLTenantUserPassword');
    return [ $dbPassword ];
}

sub checkVersion{
	my ($self, $instconfig) = @_;
	my $version =  $self->{manifest}->getVersionObject ();
	my $codeline = $self->{manifest}->getValue('codeline');
	my $componentName = $self->getComponentName();
	
	return 1 if ( $codeline ne 'REL');
	require SDB::Install::ComponentVersion;
	my $restrictVersion = new SDB::Install::ComponentVersion("1",'0','13','262519'); #first XSA version whitch support uninstall
	return 1 if ($version->isNewerThan ($restrictVersion) || $version->isEqual($restrictVersion));
	$instconfig->getMsgLst()->AddMessage("Component $componentName version ".$self->{manifest}->getVersion()." does not support uninstallation.It will be skipped from list of uninstallable components.");
    return 0;
}

sub deleteXSPostUninstallData{
	...
}
1;
